/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The root entity for resource catalog management. A resource catalog is a group of resource specifications made available through resource candidates that an organization provides to the consumers (internal consumers like its employees or B2B customers or B2C customers). Skipped properties: id,href")
@Validated
public class ResourceCatalogUpdate {
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="@type")
    protected String type = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="category")
    @Valid
    protected List<ResourceCategoryRef> category = null;

    public ResourceCatalogUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the catalog")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceCatalogUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of this catalog")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceCatalogUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="Indicates the (class) type of catalog. For resource catalogs, this will be 'ResourceCatalog'.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceCatalogUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="This field provides a link to the schema describing this REST resource")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceCatalogUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="Indicates<b> </b>the base (class) type of this REST resource")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ResourceCatalogUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Catalog version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ResourceCatalogUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the catalog is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ResourceCatalogUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceCatalogUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceCatalogUpdate category(List<ResourceCategoryRef> category) {
        this.category = category;
        return this;
    }

    public ResourceCatalogUpdate addCategoryItem(ResourceCategoryRef categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<ResourceCategoryRef>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ResourceCategoryRef> getCategory() {
        return this.category;
    }

    public void setCategory(List<ResourceCategoryRef> category) {
        this.category = category;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCatalogUpdate resourceCatalogUpdate = (ResourceCatalogUpdate)o;
        return Objects.equals(this.name, resourceCatalogUpdate.name) && Objects.equals(this.description, resourceCatalogUpdate.description) && Objects.equals(this.type, resourceCatalogUpdate.type) && Objects.equals(this.schemaLocation, resourceCatalogUpdate.schemaLocation) && Objects.equals(this.baseType, resourceCatalogUpdate.baseType) && Objects.equals(this.version, resourceCatalogUpdate.version) && Objects.equals(this.validFor, resourceCatalogUpdate.validFor) && Objects.equals(this.lifecycleStatus, resourceCatalogUpdate.lifecycleStatus) && Objects.equals(this.relatedParty, resourceCatalogUpdate.relatedParty) && Objects.equals(this.category, resourceCatalogUpdate.category);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCatalogUpdate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

