/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.ResourceCatalogUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="The root entity for resource catalog management. A resource catalog is a group of resource specifications made available through resource candidates that an organization provides to the consumers (internal consumers like its employees or B2B customers or B2C customers). Skipped properties: id,href")
@Validated
public class ResourceCatalogCreate
extends ResourceCatalogUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    public ResourceCatalogCreate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCatalogCreate resourceCatalogCreate = (ResourceCatalogCreate)o;
        return Objects.equals(this.name, resourceCatalogCreate.name) && Objects.equals(this.description, resourceCatalogCreate.description) && Objects.equals(this.type, resourceCatalogCreate.type) && Objects.equals(this.schemaLocation, resourceCatalogCreate.schemaLocation) && Objects.equals(this.baseType, resourceCatalogCreate.baseType) && Objects.equals(this.version, resourceCatalogCreate.version) && Objects.equals(this.validFor, resourceCatalogCreate.validFor) && Objects.equals(this.lastUpdate, resourceCatalogCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, resourceCatalogCreate.lifecycleStatus) && Objects.equals(this.relatedParty, resourceCatalogCreate.relatedParty) && Objects.equals(this.category, resourceCatalogCreate.category);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.type, this.schemaLocation, this.baseType, this.version, this.validFor, this.lastUpdate, this.lifecycleStatus, this.relatedParty, this.category);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCatalogCreate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

