/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceCategory;
import org.etsi.osl.tmf.rcm634.model.ResourceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The root entity for resource catalog management. A resource catalog is a group of resource specifications made available through resource candidates that an organization provides to the consumers (internal consumers like its employees or B2B customers or B2C customers).")
@Validated
@Entity(name="ResourceCatalog")
public class ResourceCatalog
extends BaseEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @Transient
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @ManyToMany(cascade={CascadeType.DETACH})
    @JoinTable
    @JsonIgnore
    private Set<ResourceCategory> categoryObj = new HashSet<ResourceCategory>();

    public ResourceCatalog id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the Catalog")
    public String getId() {
        return this.uuid;
    }

    public ResourceCatalog relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceCatalog addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    @Schema(description="List of service categories associated with this catalog")
    @Transient
    @JsonProperty(value="category")
    @Valid
    public List<ResourceCategoryRef> getCategoryRefs() {
        ArrayList<ResourceCategoryRef> category = new ArrayList<ResourceCategoryRef>();
        for (ResourceCategory serviceCategory : this.categoryObj) {
            ResourceCategoryRef scr = new ResourceCategoryRef();
            scr.setId(serviceCategory.getId());
            scr.setName(serviceCategory.getName());
            scr.setBaseType(ResourceCategoryRef.class.getName());
            category.add(scr);
        }
        return category;
    }

    public void setCategoryRefs(List<ResourceCategoryRef> crefs) {
        for (ResourceCategoryRef serviceCategoryRef : crefs) {
            ResourceCategory e = new ResourceCategory();
            e.setUuid(serviceCategoryRef.getId());
            e.setName(serviceCategoryRef.getName());
            this.categoryObj.add(e);
        }
    }

    public Set<ResourceCategory> getCategoryObj() {
        return this.categoryObj;
    }

    public void setCategoryObj(Set<ResourceCategory> categoryObj) {
        this.categoryObj = categoryObj;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCatalog resourceCatalog = (ResourceCatalog)o;
        return Objects.equals(this.id, resourceCatalog.id) && Objects.equals(this.href, resourceCatalog.href) && Objects.equals(this.name, resourceCatalog.name) && Objects.equals(this.description, resourceCatalog.description) && Objects.equals(this.type, resourceCatalog.type) && Objects.equals(this.schemaLocation, resourceCatalog.schemaLocation) && Objects.equals(this.baseType, resourceCatalog.baseType) && Objects.equals(this.version, resourceCatalog.version) && Objects.equals(this.validFor, resourceCatalog.validFor) && Objects.equals(this.lastUpdate, resourceCatalog.lastUpdate) && Objects.equals(this.lifecycleStatus, resourceCatalog.lifecycleStatus) && Objects.equals(this.relatedParty, resourceCatalog.relatedParty) && Objects.equals(this.getCategoryRefs(), resourceCatalog.getCategoryRefs());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCatalog {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.getCategoryRefs())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void addCategory(ResourceCategory cat) {
        if (!this.categoryObj.contains(cat)) {
            this.categoryObj.add(cat);
        }
    }
}

