/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.rcm634.model.ResourceCategoryRef;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="ResourceCandidate is an entity that makes a resource specification available to a catalog. A ResourceCandidate and its associated resource specification may be published - made visible - in any number of resource catalogs, or in none. Skipped properties: id,href")
@Validated
public class ResourceCandidateUpdate {
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="@type")
    protected String type = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="lastUpdate")
    protected OffsetDateTime lastUpdate = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="category")
    @Valid
    protected List<ResourceCategoryRef> category = null;
    @JsonProperty(value="resourceSpecification")
    protected ResourceSpecificationRef resourceSpecification = null;

    public ResourceCandidateUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name given to this REST resource")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceCandidateUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of this REST resource")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceCandidateUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="Class type of this REST resource")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceCandidateUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="This field provides a link to the schema describing this REST resource")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceCandidateUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The (immediate) base class type of this REST resource")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ResourceCandidateUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="the version of resource candidate")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ResourceCandidateUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which this REST resource is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceCandidateUpdate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update of this REST resource")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public ResourceCandidateUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status of the resource candidate.")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ResourceCandidateUpdate category(List<ResourceCategoryRef> category) {
        this.category = category;
        return this;
    }

    public ResourceCandidateUpdate addCategoryItem(ResourceCategoryRef categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<ResourceCategoryRef>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ResourceCategoryRef> getCategory() {
        return this.category;
    }

    public void setCategory(List<ResourceCategoryRef> category) {
        this.category = category;
    }

    public ResourceCandidateUpdate resourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceSpecificationRef getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCandidateUpdate resourceCandidateUpdate = (ResourceCandidateUpdate)o;
        return Objects.equals(this.name, resourceCandidateUpdate.name) && Objects.equals(this.description, resourceCandidateUpdate.description) && Objects.equals(this.type, resourceCandidateUpdate.type) && Objects.equals(this.schemaLocation, resourceCandidateUpdate.schemaLocation) && Objects.equals(this.baseType, resourceCandidateUpdate.baseType) && Objects.equals(this.version, resourceCandidateUpdate.version) && Objects.equals(this.validFor, resourceCandidateUpdate.validFor) && Objects.equals(this.lastUpdate, resourceCandidateUpdate.lastUpdate) && Objects.equals(this.lifecycleStatus, resourceCandidateUpdate.lifecycleStatus) && Objects.equals(this.category, resourceCandidateUpdate.category) && Objects.equals(this.resourceSpecification, resourceCandidateUpdate.resourceSpecification);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.type, this.schemaLocation, this.baseType, this.version, this.validFor, this.lastUpdate, this.lifecycleStatus, this.category, this.resourceSpecification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCandidateUpdate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

