/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="ResourceCandidate is an entity that makes a resource specification available to a catalog. A ResourceCandidate and its associated resource specification may be published - made visible - in any number of resource catalogs, or in none.")
@Validated
public class ResourceCandidateRef
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="version")
    private String version = null;

    public ResourceCandidateRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the resource candidate")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ResourceCandidateRef href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Reference of the resource candidate")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public ResourceCandidateRef version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Version of the resource candidate")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCandidateRef resourceCandidateRef = (ResourceCandidateRef)o;
        return Objects.equals(this.id, resourceCandidateRef.id) && Objects.equals(this.href, resourceCandidateRef.href) && Objects.equals(this.version, resourceCandidateRef.version) && Objects.equals(this.name, resourceCandidateRef.name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCandidateRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

