/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.ResourceCandidateUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="ResourceCandidate is an entity that makes a resource specification available to a catalog. A ResourceCandidate and its associated resource specification may be published - made visible - in any number of resource catalogs, or in none. Skipped properties: id,href")
@Validated
public class ResourceCandidateCreate
extends ResourceCandidateUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    @Override
    public ResourceCandidateCreate name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ResourceCandidateCreate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Override
    @Schema(description="Date and time of the last update of this REST resource")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCandidateCreate resourceCandidateCreate = (ResourceCandidateCreate)o;
        return Objects.equals(this.name, resourceCandidateCreate.name) && Objects.equals(this.description, resourceCandidateCreate.description) && Objects.equals(this.type, resourceCandidateCreate.type) && Objects.equals(this.schemaLocation, resourceCandidateCreate.schemaLocation) && Objects.equals(this.baseType, resourceCandidateCreate.baseType) && Objects.equals(this.version, resourceCandidateCreate.version) && Objects.equals(this.validFor, resourceCandidateCreate.validFor) && Objects.equals(this.lastUpdate, resourceCandidateCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, resourceCandidateCreate.lifecycleStatus) && Objects.equals(this.category, resourceCandidateCreate.category) && Objects.equals(this.resourceSpecification, resourceCandidateCreate.resourceSpecification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.description, this.type, this.schemaLocation, this.baseType, this.version, this.validFor, this.lastUpdate, this.lifecycleStatus, this.category, this.resourceSpecification);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCandidateCreate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

