/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.rcm634.model.ResourceCategory;
import org.etsi.osl.tmf.rcm634.model.ResourceCategoryRef;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="ResourceCandidate is an entity that makes a resource specification available to a catalog. A ResourceCandidate and its associated resource specification may be published - made visible - in any number of resource catalogs, or in none.")
@Validated
@Entity(name="ResourceCandidate")
public class ResourceCandidate
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @ManyToMany(mappedBy="resourceCandidateObj", cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JsonIgnore
    private Set<ResourceCategory> categoryObj = new HashSet<ResourceCategory>();
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinColumn(name="resource_specid", referencedColumnName="uuid")
    @JsonIgnore
    private ResourceSpecification resourceSpecificationObj = null;

    public ResourceCandidate() {
        this.type = "ResourceCandidate";
        this.baseType = "BaseEntity";
    }

    @Schema(description="The resource specification implied by this candidate")
    @Transient
    @JsonProperty(value="resourceSpecification")
    @Valid
    public ResourceSpecificationRef getResourceSpecificationRef() {
        if (this.resourceSpecificationObj != null) {
            ResourceSpecificationRef sref = new ResourceSpecificationRef();
            sref.setId(this.resourceSpecificationObj.getUuid());
            sref.setName(this.resourceSpecificationObj.getName());
            sref.setVersion(this.resourceSpecificationObj.getVersion());
            sref.setBaseType(ResourceSpecificationRef.class.getName());
            return sref;
        }
        return null;
    }

    public ResourceSpecification getResourceSpecificationObj() {
        return this.resourceSpecificationObj;
    }

    public void setResourceSpecificationObj(ResourceSpecification resourceSpecificationObj) {
        this.resourceSpecificationObj = resourceSpecificationObj;
    }

    @Schema(description="The category specification implied by this candidate")
    @Transient
    @JsonProperty(value="category")
    @Valid
    public List<ResourceCategoryRef> getCategory() {
        ArrayList<ResourceCategoryRef> category = new ArrayList<ResourceCategoryRef>();
        for (ResourceCategory resourceCategory : this.categoryObj) {
            ResourceCategoryRef scr = new ResourceCategoryRef();
            scr.setId(resourceCategory.getId());
            scr.setName(resourceCategory.getName());
            scr.setBaseType(ResourceCategoryRef.class.getName());
            category.add(scr);
        }
        return category;
    }

    @Schema(description="Unique identifier of this REST resource")
    public String getId() {
        return this.uuid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCandidate resourceCandidate = (ResourceCandidate)o;
        return Objects.equals(this.id, resourceCandidate.id) && Objects.equals(this.href, resourceCandidate.href) && Objects.equals(this.name, resourceCandidate.name) && Objects.equals(this.description, resourceCandidate.description) && Objects.equals(this.type, resourceCandidate.type) && Objects.equals(this.schemaLocation, resourceCandidate.schemaLocation) && Objects.equals(this.baseType, resourceCandidate.baseType) && Objects.equals(this.version, resourceCandidate.version) && Objects.equals(this.validFor, resourceCandidate.validFor) && Objects.equals(this.lastUpdate, resourceCandidate.lastUpdate) && Objects.equals(this.lifecycleStatus, resourceCandidate.lifecycleStatus) && Objects.equals(this.getCategory(), resourceCandidate.getCategory()) && Objects.equals(this.getResourceSpecificationRef(), resourceCandidate.getResourceSpecificationRef());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCandidate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.getCategory())).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.getResourceSpecificationRef())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Set<ResourceCategory> getCategoryObj() {
        return this.categoryObj;
    }

    public void setCategoryObj(Set<ResourceCategory> categoryObj) {
        this.categoryObj = categoryObj;
    }
}

