/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="This is a concrete class that is used to define the invariant characteristics and behavior (attributes, methods, constraints, and relationships) of a PhysicalResource. Skipped properties: id,href,id,href,lastUpdate,@type")
@Validated
public class PhysicalResourceSpecificationUpdate
extends ResourceSpecificationUpdate {
    @JsonProperty(value="model")
    protected String model = null;
    @JsonProperty(value="part")
    protected String part = null;
    @JsonProperty(value="sku")
    protected String sku = null;
    @JsonProperty(value="vendor")
    protected String vendor = null;

    @Schema(description="This is a string that represents a manufacturer-allocated number used to identify the general type and/or category of the hardware item. This, in combination with the Part and the Vendor, identify different types of hardware items. The SerialNumber can then be used to differentiate between different instances of the same type of hardware item. This is an optional attribute.")
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public PhysicalResourceSpecificationUpdate part(String part) {
        this.part = part;
        return this;
    }

    @Schema(description="This is a string that defines a manufacturer-allocated part number assigned by the organization that manufactures the hardware item. This, in combination with the Model and the Vendor, identify different types of hardware items. The SerialNumber can then be used to differentiate between different instances of the same type of hardware item. This is a REQUIRED attribute.")
    public String getPart() {
        return this.part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public PhysicalResourceSpecificationUpdate sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Schema(description="This is a string that defines the manufacturer-allocated Stock Keeping Unit (SKU) number of the hardware item. This is an optional attribute.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public PhysicalResourceSpecificationUpdate vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    @Schema(description="This is a string that defines the name of the manufacturer. This, in combination with the Model and the Part, identify different types of hardware items. The SerialNumber can then be used to differentiate between different instances of the same type of hardware item. This is a REQUIRED attribute for a physical resource.")
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalResourceSpecificationUpdate physicalResourceSpecUpdate = (PhysicalResourceSpecificationUpdate)o;
        return Objects.equals(this.name, physicalResourceSpecUpdate.name) && Objects.equals(this.description, physicalResourceSpecUpdate.description) && Objects.equals(this.schemaLocation, physicalResourceSpecUpdate.schemaLocation) && Objects.equals(this.baseType, physicalResourceSpecUpdate.baseType) && Objects.equals(this.version, physicalResourceSpecUpdate.version) && Objects.equals(this.validFor, physicalResourceSpecUpdate.validFor) && Objects.equals(this.lifecycleStatus, physicalResourceSpecUpdate.lifecycleStatus) && Objects.equals(this.isBundle, physicalResourceSpecUpdate.isBundle) && Objects.equals(this.category, physicalResourceSpecUpdate.category) && Objects.equals(this.model, physicalResourceSpecUpdate.model) && Objects.equals(this.part, physicalResourceSpecUpdate.part) && Objects.equals(this.sku, physicalResourceSpecUpdate.sku) && Objects.equals(this.vendor, physicalResourceSpecUpdate.vendor) && Objects.equals(this.targetResourceSchema, physicalResourceSpecUpdate.targetResourceSchema) && Objects.equals(this.featureSpecification, physicalResourceSpecUpdate.featureSpecification) && Objects.equals(this.attachment, physicalResourceSpecUpdate.attachment) && Objects.equals(this.relatedParty, physicalResourceSpecUpdate.relatedParty) && Objects.equals(this.resourceSpecificationCharacteristic, physicalResourceSpecUpdate.resourceSpecificationCharacteristic) && Objects.equals(this.resourceSpecificationRelationship, physicalResourceSpecUpdate.resourceSpecificationRelationship);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhysicalResourceSpecUpdate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    part: ").append(this.toIndentedString(this.part)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString(this.vendor)).append("\n");
        sb.append("    targetResourceSchema: ").append(this.toIndentedString(this.targetResourceSchema)).append("\n");
        sb.append("    featureSpecification: ").append(this.toIndentedString(this.featureSpecification)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecificationCharacteristic: ").append(this.toIndentedString(this.resourceSpecificationCharacteristic)).append("\n");
        sb.append("    resourceSpecRelationship: ").append(this.toIndentedString(this.resourceSpecificationRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

