/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.springframework.validation.annotation.Validated;

@Schema(description="This is a concrete class that is used to define the invariant characteristics and behavior (attributes, methods, constraints, and relationships) of a PhysicalResource.")
@Validated
@Entity(name="PhysicalRspec")
public class PhysicalResourceSpecification
extends ResourceSpecification {
    @JsonProperty(value="model")
    private String model = null;
    @JsonProperty(value="part")
    private String part = null;
    @JsonProperty(value="sku")
    private String sku = null;
    @JsonProperty(value="vendor")
    private String vendor = null;

    public PhysicalResourceSpecification() {
        this.baseType = "ResourceSpecification";
        this.type = "PhysicalResourceSpecification";
    }

    public PhysicalResourceSpecification model(String model) {
        this.model = model;
        return this;
    }

    @Schema(description="This is a string that represents a manufacturer-allocated number used to identify the general type and/or category of the hardware item. This, in combination with the Part and the Vendor, identify different types of hardware items. The SerialNumber can then be used to differentiate between different instances of the same type of hardware item. This is an optional attribute.")
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public PhysicalResourceSpecification part(String part) {
        this.part = part;
        return this;
    }

    @Schema(description="This is a string that defines a manufacturer-allocated part number assigned by the organization that manufactures the hardware item. This, in combination with the Model and the Vendor, identify different types of hardware items. The SerialNumber can then be used to differentiate between different instances of the same type of hardware item. This is a REQUIRED attribute.")
    public String getPart() {
        return this.part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public PhysicalResourceSpecification sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Schema(description="This is a string that defines the manufacturer-allocated Stock Keeping Unit (SKU) number of the hardware item. This is an optional attribute.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public PhysicalResourceSpecification vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    @Schema(description="This is a string that defines the name of the manufacturer. This, in combination with the Model and the Part, identify different types of hardware items. The SerialNumber can then be used to differentiate between different instances of the same type of hardware item. This is a REQUIRED attribute for a physical resource.")
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalResourceSpecification physicalResourceSpecification = (PhysicalResourceSpecification)o;
        return Objects.equals(this.uuid, physicalResourceSpecification.uuid) && Objects.equals(this.href, physicalResourceSpecification.href) && Objects.equals(this.category, physicalResourceSpecification.category) && Objects.equals(this.description, physicalResourceSpecification.description) && Objects.equals(this.isBundle, physicalResourceSpecification.isBundle) && Objects.equals(this.lastUpdate, physicalResourceSpecification.lastUpdate) && Objects.equals(this.lifecycleStatus, physicalResourceSpecification.lifecycleStatus) && Objects.equals(this.model, physicalResourceSpecification.model) && Objects.equals(this.name, physicalResourceSpecification.name) && Objects.equals(this.part, physicalResourceSpecification.part) && Objects.equals(this.sku, physicalResourceSpecification.sku) && Objects.equals(this.vendor, physicalResourceSpecification.vendor) && Objects.equals(this.version, physicalResourceSpecification.version) && Objects.equals(this.attachment, physicalResourceSpecification.attachment) && Objects.equals(this.featureSpecification, physicalResourceSpecification.featureSpecification) && Objects.equals(this.relatedParty, physicalResourceSpecification.relatedParty) && Objects.equals(this.resourceSpecCharacteristic, physicalResourceSpecification.resourceSpecCharacteristic) && Objects.equals(this.resourceSpecRelationship, physicalResourceSpecification.resourceSpecRelationship) && Objects.equals(this.targetResourceSchema, physicalResourceSpecification.targetResourceSchema) && Objects.equals(this.validFor, physicalResourceSpecification.validFor) && Objects.equals(this.baseType, physicalResourceSpecification.baseType) && Objects.equals(this.schemaLocation, physicalResourceSpecification.schemaLocation) && Objects.equals(this.type, physicalResourceSpecification.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhysicalResourceSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    part: ").append(this.toIndentedString(this.part)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString(this.vendor)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    featureSpecification: ").append(this.toIndentedString(this.featureSpecification)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecCharacteristic: ").append(this.toIndentedString(this.resourceSpecCharacteristic)).append("\n");
        sb.append("    resourceSpecRelationship: ").append(this.toIndentedString(this.resourceSpecRelationship)).append("\n");
        sb.append("    targetResourceSchema: ").append(this.toIndentedString(this.targetResourceSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

