/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.JobStateType;
import org.springframework.validation.annotation.Validated;

@Schema(description="Represents a task used to import resources from a file Skipped properties: id,href")
@Validated
public class ImportJobCreate {
    @JsonProperty(value="completionDate")
    private OffsetDateTime completionDate = null;
    @JsonProperty(value="contentType")
    private String contentType = null;
    @JsonProperty(value="creationDate")
    private OffsetDateTime creationDate = null;
    @JsonProperty(value="errorLog")
    private String errorLog = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="status")
    private JobStateType status = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ImportJobCreate completionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Schema(description="Date at which the job was completed")
    @Valid
    public OffsetDateTime getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
    }

    public ImportJobCreate contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Schema(description="Indicates the format of the imported data")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ImportJobCreate creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Schema(description="Date at which the job was created")
    @Valid
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public ImportJobCreate errorLog(String errorLog) {
        this.errorLog = errorLog;
        return this;
    }

    @Schema(description="Reason for failure if status is failed")
    public String getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(String errorLog) {
        this.errorLog = errorLog;
    }

    public ImportJobCreate path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="URL of the root resource where the content of the file specified by the import job must be applied")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ImportJobCreate url(String url) {
        this.url = url;
        return this;
    }

    @Schema(description="URL of the file containing the data to be imported")
    @NotNull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ImportJobCreate status(JobStateType status) {
        this.status = status;
        return this;
    }

    @Schema(description="")
    @Valid
    public JobStateType getStatus() {
        return this.status;
    }

    public void setStatus(JobStateType status) {
        this.status = status;
    }

    public ImportJobCreate _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ImportJobCreate _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ImportJobCreate _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportJobCreate importJobCreate = (ImportJobCreate)o;
        return Objects.equals(this.completionDate, importJobCreate.completionDate) && Objects.equals(this.contentType, importJobCreate.contentType) && Objects.equals(this.creationDate, importJobCreate.creationDate) && Objects.equals(this.errorLog, importJobCreate.errorLog) && Objects.equals(this.path, importJobCreate.path) && Objects.equals(this.url, importJobCreate.url) && Objects.equals((Object)this.status, (Object)importJobCreate.status) && Objects.equals(this._atBaseType, importJobCreate._atBaseType) && Objects.equals(this._atSchemaLocation, importJobCreate._atSchemaLocation) && Objects.equals(this._atType, importJobCreate._atType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.completionDate, this.contentType, this.creationDate, this.errorLog, this.path, this.url, this.status, this._atBaseType, this._atSchemaLocation, this._atType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportJobCreate {\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    errorLog: ").append(this.toIndentedString(this.errorLog)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

