/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Configuration feature")
@Validated
@Entity(name="RCMFeatureSpecRel")
public class FeatureSpecificationRelationship
extends BaseEntity {
    @JsonProperty(value="featureId")
    private String featureId = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="resourceSpecificationHref")
    private String resourceSpecificationHref = null;
    @JsonProperty(value="resourceSpecificationId")
    private String resourceSpecificationId = null;

    public FeatureSpecificationRelationship featureId(String featureId) {
        this.featureId = featureId;
        return this;
    }

    @Schema(description="Unique identifier of the target feature specification.")
    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    @Override
    public FeatureSpecificationRelationship name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="This is the name of the target feature specification.")
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public FeatureSpecificationRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="This is the type of the feature specification relationship.")
    @NotNull
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public FeatureSpecificationRelationship resourceSpecificationHref(String resourceSpecificationHref) {
        this.resourceSpecificationHref = resourceSpecificationHref;
        return this;
    }

    @Schema(description="Hyperlink reference to the resource specification containing the target feature")
    public String getResourceSpecificationHref() {
        return this.resourceSpecificationHref;
    }

    public void setResourceSpecificationHref(String resourceSpecificationHref) {
        this.resourceSpecificationHref = resourceSpecificationHref;
    }

    public FeatureSpecificationRelationship resourceSpecificationId(String resourceSpecificationId) {
        this.resourceSpecificationId = resourceSpecificationId;
        return this;
    }

    @Schema(description="Unique identifier of the resource specification containing the target feature")
    public String getResourceSpecificationId() {
        return this.resourceSpecificationId;
    }

    public void setResourceSpecificationId(String resourceSpecificationId) {
        this.resourceSpecificationId = resourceSpecificationId;
    }

    public FeatureSpecificationRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Override
    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    @Override
    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public FeatureSpecificationRelationship _atBaseType(String _atBaseType) {
        this.baseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this.baseType = _atBaseType;
    }

    public FeatureSpecificationRelationship _atSchemaLocation(String _atSchemaLocation) {
        this.schemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this.schemaLocation = _atSchemaLocation;
    }

    public FeatureSpecificationRelationship _atType(String _atType) {
        this.type = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String _atType) {
        this.type = _atType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSpecificationRelationship featureSpecificationRelationship = (FeatureSpecificationRelationship)o;
        return Objects.equals(this.featureId, featureSpecificationRelationship.featureId) && Objects.equals(this.name, featureSpecificationRelationship.name) && Objects.equals(this.relationshipType, featureSpecificationRelationship.relationshipType) && Objects.equals(this.resourceSpecificationHref, featureSpecificationRelationship.resourceSpecificationHref) && Objects.equals(this.resourceSpecificationId, featureSpecificationRelationship.resourceSpecificationId) && Objects.equals(this.validFor, featureSpecificationRelationship.validFor) && Objects.equals(this.baseType, featureSpecificationRelationship.baseType) && Objects.equals(this.schemaLocation, featureSpecificationRelationship.schemaLocation) && Objects.equals(this.type, featureSpecificationRelationship.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.featureId, this.name, this.relationshipType, this.resourceSpecificationHref, this.resourceSpecificationId, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSpecificationRelationship {\n");
        sb.append("    featureId: ").append(this.toIndentedString(this.featureId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    resourceSpecificationHref: ").append(this.toIndentedString(this.resourceSpecificationHref)).append("\n");
        sb.append("    resourceSpecificationId: ").append(this.toIndentedString(this.resourceSpecificationId)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

