/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among FeatureSpecificationCharacteristics.")
@Validated
@Entity(name="RCMFeatureSpecCharRel")
public class FeatureSpecificationCharacteristicRelationship
extends BaseRootNamedEntity {
    @JsonProperty(value="characteristicId")
    private String characteristicId = null;
    @JsonProperty(value="featureId")
    private String featureId = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="resourceSpecificationHref")
    private String resourceSpecificationHref = null;
    @JsonProperty(value="resourceSpecificationId")
    private String resourceSpecificationId = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public FeatureSpecificationCharacteristicRelationship characteristicId(String characteristicId) {
        this.characteristicId = characteristicId;
        return this;
    }

    @Schema(description="Unique identifier of the characteristic within the the target feature specification")
    public String getCharacteristicId() {
        return this.characteristicId;
    }

    public void setCharacteristicId(String characteristicId) {
        this.characteristicId = characteristicId;
    }

    public FeatureSpecificationCharacteristicRelationship featureId(String featureId) {
        this.featureId = featureId;
        return this;
    }

    @Schema(description="Unique identifier of the target feature specification within the resource specification.")
    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    @Override
    public FeatureSpecificationCharacteristicRelationship name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the target characteristic")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public FeatureSpecificationCharacteristicRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as aggregation, migration, substitution, dependency, exclusivity")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public FeatureSpecificationCharacteristicRelationship resourceSpecificationHref(String resourceSpecificationHref) {
        this.resourceSpecificationHref = resourceSpecificationHref;
        return this;
    }

    @Schema(description="Hyperlink reference to the resource specification containing the target feature and feature characteristic")
    public String getResourceSpecificationHref() {
        return this.resourceSpecificationHref;
    }

    public void setResourceSpecificationHref(String resourceSpecificationHref) {
        this.resourceSpecificationHref = resourceSpecificationHref;
    }

    public FeatureSpecificationCharacteristicRelationship resourceSpecificationId(String resourceSpecificationId) {
        this.resourceSpecificationId = resourceSpecificationId;
        return this;
    }

    @Schema(description="Unique identifier of the resource specification containing the target feature and feature characteristic")
    public String getResourceSpecificationId() {
        return this.resourceSpecificationId;
    }

    public void setResourceSpecificationId(String resourceSpecificationId) {
        this.resourceSpecificationId = resourceSpecificationId;
    }

    public FeatureSpecificationCharacteristicRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSpecificationCharacteristicRelationship featureSpecificationCharacteristicRelationship = (FeatureSpecificationCharacteristicRelationship)o;
        return Objects.equals(this.characteristicId, featureSpecificationCharacteristicRelationship.characteristicId) && Objects.equals(this.featureId, featureSpecificationCharacteristicRelationship.featureId) && Objects.equals(this.name, featureSpecificationCharacteristicRelationship.name) && Objects.equals(this.relationshipType, featureSpecificationCharacteristicRelationship.relationshipType) && Objects.equals(this.resourceSpecificationHref, featureSpecificationCharacteristicRelationship.resourceSpecificationHref) && Objects.equals(this.resourceSpecificationId, featureSpecificationCharacteristicRelationship.resourceSpecificationId) && Objects.equals(this.validFor, featureSpecificationCharacteristicRelationship.validFor) && Objects.equals(this.baseType, featureSpecificationCharacteristicRelationship.baseType) && Objects.equals(this.schemaLocation, featureSpecificationCharacteristicRelationship.schemaLocation) && Objects.equals(this.type, featureSpecificationCharacteristicRelationship.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.characteristicId, this.featureId, this.name, this.relationshipType, this.resourceSpecificationHref, this.resourceSpecificationId, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSpecificationCharacteristicRelationship {\n");
        sb.append("    characteristicId: ").append(this.toIndentedString(this.characteristicId)).append("\n");
        sb.append("    featureId: ").append(this.toIndentedString(this.featureId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    resourceSpecificationHref: ").append(this.toIndentedString(this.resourceSpecificationHref)).append("\n");
        sb.append("    resourceSpecificationId: ").append(this.toIndentedString(this.resourceSpecificationId)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

