/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.rcm634.model.FeatureSpecificationCharacteristicRelationship;
import org.etsi.osl.tmf.rcm634.model.FeatureSpecificationCharacteristicValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="Configuration feature characteristic specification.")
@Validated
@Entity(name="RCMFeatureSpecChar")
public class FeatureSpecificationCharacteristic
extends BaseEntity {
    @JsonProperty(value="configurable")
    private Boolean configurable = null;
    @JsonProperty(value="extensible")
    private Boolean extensible = null;
    @JsonProperty(value="isUnique")
    private Boolean isUnique = null;
    @JsonProperty(value="maxCardinality")
    private Integer maxCardinality = null;
    @JsonProperty(value="minCardinality")
    private Integer minCardinality = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="featureSpecCharRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<FeatureSpecificationCharacteristicRelationship> featureSpecCharRelationship = new HashSet<FeatureSpecificationCharacteristicRelationship>();
    @JsonProperty(value="featureSpecCharacteristicValue")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<FeatureSpecificationCharacteristicValue> featureSpecCharacteristicValue = new HashSet<FeatureSpecificationCharacteristicValue>();

    public FeatureSpecificationCharacteristic configurable(Boolean configurable) {
        this.configurable = configurable;
        return this;
    }

    @Schema(description="True is the feature is configurable.")
    public Boolean isConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    public FeatureSpecificationCharacteristic extensible(Boolean extensible) {
        this.extensible = extensible;
        return this;
    }

    @Schema(description="An indicator that specifies that the values for the characteristic can be extended by adding new values when instantiating a characteristic for a feature.")
    public Boolean isExtensible() {
        return this.extensible;
    }

    public void setExtensible(Boolean extensible) {
        this.extensible = extensible;
    }

    public FeatureSpecificationCharacteristic isUnique(Boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    @Schema(description="An indicator that specifies if a value is unique for the specification.")
    public Boolean isIsUnique() {
        return this.isUnique;
    }

    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    public FeatureSpecificationCharacteristic maxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
        return this;
    }

    @Schema(description="The maximum number of instances a CharacteristicValue can take on.")
    public Integer getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public FeatureSpecificationCharacteristic minCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
        return this;
    }

    @Schema(description="The minimum number of instances a CharacteristicValue can take on.")
    public Integer getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
    }

    @Override
    public FeatureSpecificationCharacteristic name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="This is the name for the feature charateristic.")
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public FeatureSpecificationCharacteristic regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="A rule or principle represented in regular expression used to derive the value of a characteristic value.")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public FeatureSpecificationCharacteristic valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on.")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public FeatureSpecificationCharacteristic featureSpecCharRelationship(Set<FeatureSpecificationCharacteristicRelationship> featureSpecCharRelationship) {
        this.featureSpecCharRelationship = featureSpecCharRelationship;
        return this;
    }

    public FeatureSpecificationCharacteristic addFeatureSpecCharRelationshipItem(FeatureSpecificationCharacteristicRelationship featureSpecCharRelationshipItem) {
        if (this.featureSpecCharRelationship == null) {
            this.featureSpecCharRelationship = new HashSet<FeatureSpecificationCharacteristicRelationship>();
        }
        this.featureSpecCharRelationship.add(featureSpecCharRelationshipItem);
        return this;
    }

    @Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among feature characteristics.")
    @Valid
    public Set<FeatureSpecificationCharacteristicRelationship> getFeatureSpecCharRelationship() {
        return this.featureSpecCharRelationship;
    }

    public void setFeatureSpecCharRelationship(Set<FeatureSpecificationCharacteristicRelationship> featureSpecCharRelationship) {
        this.featureSpecCharRelationship = featureSpecCharRelationship;
    }

    public FeatureSpecificationCharacteristic featureSpecCharacteristicValue(Set<FeatureSpecificationCharacteristicValue> featureSpecCharacteristicValue) {
        this.featureSpecCharacteristicValue = featureSpecCharacteristicValue;
        return this;
    }

    public FeatureSpecificationCharacteristic addFeatureSpecCharacteristicValueItem(FeatureSpecificationCharacteristicValue featureSpecCharacteristicValueItem) {
        if (this.featureSpecCharacteristicValue == null) {
            this.featureSpecCharacteristicValue = new HashSet<FeatureSpecificationCharacteristicValue>();
        }
        this.featureSpecCharacteristicValue.add(featureSpecCharacteristicValueItem);
        return this;
    }

    @Schema(description="Used to define a set of attributes, each of which can be assigned to a corresponding set of attributes in a FeatureCharacteristic object.")
    @Valid
    public Set<FeatureSpecificationCharacteristicValue> getFeatureSpecCharacteristicValue() {
        return this.featureSpecCharacteristicValue;
    }

    public void setFeatureSpecCharacteristicValue(Set<FeatureSpecificationCharacteristicValue> featureSpecCharacteristicValue) {
        this.featureSpecCharacteristicValue = featureSpecCharacteristicValue;
    }

    public FeatureSpecificationCharacteristic validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Override
    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    @Override
    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public FeatureSpecificationCharacteristic _atValueSchemaLocation(String _atValueSchemaLocation) {
        this.schemaLocation = _atValueSchemaLocation;
        return this;
    }

    @Schema(description="This (optional) field provides a link to the schema describing the value type.")
    public String getAtValueSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtValueSchemaLocation(String _atValueSchemaLocation) {
        this.schemaLocation = _atValueSchemaLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSpecificationCharacteristic featureSpecificationCharacteristic = (FeatureSpecificationCharacteristic)o;
        return Objects.equals(this.configurable, featureSpecificationCharacteristic.configurable) && Objects.equals(this.extensible, featureSpecificationCharacteristic.extensible) && Objects.equals(this.isUnique, featureSpecificationCharacteristic.isUnique) && Objects.equals(this.maxCardinality, featureSpecificationCharacteristic.maxCardinality) && Objects.equals(this.minCardinality, featureSpecificationCharacteristic.minCardinality) && Objects.equals(this.name, featureSpecificationCharacteristic.name) && Objects.equals(this.regex, featureSpecificationCharacteristic.regex) && Objects.equals(this.valueType, featureSpecificationCharacteristic.valueType) && Objects.equals(this.featureSpecCharRelationship, featureSpecificationCharacteristic.featureSpecCharRelationship) && Objects.equals(this.featureSpecCharacteristicValue, featureSpecificationCharacteristic.featureSpecCharacteristicValue) && Objects.equals(this.validFor, featureSpecificationCharacteristic.validFor) && Objects.equals(this.baseType, featureSpecificationCharacteristic.baseType) && Objects.equals(this.schemaLocation, featureSpecificationCharacteristic.schemaLocation) && Objects.equals(this.type, featureSpecificationCharacteristic.type) && Objects.equals(this.schemaLocation, featureSpecificationCharacteristic.schemaLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configurable, this.extensible, this.isUnique, this.maxCardinality, this.minCardinality, this.name, this.regex, this.valueType, this.featureSpecCharRelationship, this.featureSpecCharacteristicValue, this.validFor, this.baseType, this.schemaLocation, this.type, this.schemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSpecificationCharacteristic {\n");
        sb.append("    configurable: ").append(this.toIndentedString(this.configurable)).append("\n");
        sb.append("    extensible: ").append(this.toIndentedString(this.extensible)).append("\n");
        sb.append("    isUnique: ").append(this.toIndentedString(this.isUnique)).append("\n");
        sb.append("    maxCardinality: ").append(this.toIndentedString(this.maxCardinality)).append("\n");
        sb.append("    minCardinality: ").append(this.toIndentedString(this.minCardinality)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    featureSpecCharRelationship: ").append(this.toIndentedString(this.featureSpecCharRelationship)).append("\n");
        sb.append("    featureSpecCharacteristicValue: ").append(this.toIndentedString(this.featureSpecCharacteristicValue)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atValueSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

