/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.rcm634.model.ConstraintRef;
import org.etsi.osl.tmf.rcm634.model.FeatureSpecificationCharacteristic;
import org.etsi.osl.tmf.rcm634.model.FeatureSpecificationRelationship;
import org.springframework.validation.annotation.Validated;

@Schema(description="Specification for applicable configuration features for a resource specification.")
@Validated
@Entity(name="RCMFeatureSpec")
public class FeatureSpecification
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="constraint")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ConstraintRef> constraint = new HashSet<ConstraintRef>();
    @JsonProperty(value="featureSpecCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<FeatureSpecificationCharacteristic> featureSpecCharacteristic = new HashSet<FeatureSpecificationCharacteristic>();
    @JsonProperty(value="featureSpecRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<FeatureSpecificationRelationship> featureSpecRelationship = new HashSet<FeatureSpecificationRelationship>();
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public FeatureSpecification id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of the feature specification. Must be locally unique within the containing resource specification, thus allowing direct access to the feature spec.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FeatureSpecification isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="A flag indicating if this is a feature group (true) or not (false)")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public FeatureSpecification isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(description="A flag indicating if the feature is enabled (true) or not (false)")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public FeatureSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Unique name given to the feature specification")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public FeatureSpecification version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Version of the feature specification")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public FeatureSpecification constraint(Set<ConstraintRef> constraint) {
        this.constraint = constraint;
        return this;
    }

    public FeatureSpecification addConstraintItem(ConstraintRef constraintItem) {
        if (this.constraint == null) {
            this.constraint = new HashSet<ConstraintRef>();
        }
        this.constraint.add(constraintItem);
        return this;
    }

    @Schema(description="This is a list of feature constraints")
    @Valid
    public Set<ConstraintRef> getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Set<ConstraintRef> constraint) {
        this.constraint = constraint;
    }

    public FeatureSpecification featureSpecCharacteristic(Set<FeatureSpecificationCharacteristic> featureSpecCharacteristic) {
        this.featureSpecCharacteristic = featureSpecCharacteristic;
        return this;
    }

    public FeatureSpecification addFeatureSpecCharacteristicItem(FeatureSpecificationCharacteristic featureSpecCharacteristicItem) {
        if (this.featureSpecCharacteristic == null) {
            this.featureSpecCharacteristic = new HashSet<FeatureSpecificationCharacteristic>();
        }
        this.featureSpecCharacteristic.add(featureSpecCharacteristicItem);
        return this;
    }

    @Schema(description="This is a list of characteristics for a particular feature")
    @Valid
    public Set<FeatureSpecificationCharacteristic> getFeatureSpecCharacteristic() {
        return this.featureSpecCharacteristic;
    }

    public void setFeatureSpecCharacteristic(Set<FeatureSpecificationCharacteristic> featureSpecCharacteristic) {
        this.featureSpecCharacteristic = featureSpecCharacteristic;
    }

    public FeatureSpecification featureSpecRelationship(Set<FeatureSpecificationRelationship> featureSpecRelationship) {
        this.featureSpecRelationship = featureSpecRelationship;
        return this;
    }

    public FeatureSpecification addFeatureSpecRelationshipItem(FeatureSpecificationRelationship featureSpecRelationshipItem) {
        if (this.featureSpecRelationship == null) {
            this.featureSpecRelationship = new HashSet<FeatureSpecificationRelationship>();
        }
        this.featureSpecRelationship.add(featureSpecRelationshipItem);
        return this;
    }

    @Schema(description="A dependency, exclusivity or aggratation relationship between/among feature specifications.")
    @Valid
    public Set<FeatureSpecificationRelationship> getFeatureSpecRelationship() {
        return this.featureSpecRelationship;
    }

    public void setFeatureSpecRelationship(Set<FeatureSpecificationRelationship> featureSpecRelationship) {
        this.featureSpecRelationship = featureSpecRelationship;
    }

    public FeatureSpecification validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public FeatureSpecification baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public FeatureSpecification schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public FeatureSpecification type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSpecification featureSpecification = (FeatureSpecification)o;
        return Objects.equals(this.id, featureSpecification.id) && Objects.equals(this.isBundle, featureSpecification.isBundle) && Objects.equals(this.isEnabled, featureSpecification.isEnabled) && Objects.equals(this.name, featureSpecification.name) && Objects.equals(this.version, featureSpecification.version) && Objects.equals(this.constraint, featureSpecification.constraint) && Objects.equals(this.featureSpecCharacteristic, featureSpecification.featureSpecCharacteristic) && Objects.equals(this.featureSpecRelationship, featureSpecification.featureSpecRelationship) && Objects.equals(this.validFor, featureSpecification.validFor) && Objects.equals(this.baseType, featureSpecification.baseType) && Objects.equals(this.schemaLocation, featureSpecification.schemaLocation) && Objects.equals(this.type, featureSpecification.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.isBundle, this.isEnabled, this.name, this.version, this.constraint, this.featureSpecCharacteristic, this.featureSpecRelationship, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    constraint: ").append(this.toIndentedString(this.constraint)).append("\n");
        sb.append("    featureSpecCharacteristic: ").append(this.toIndentedString(this.featureSpecCharacteristic)).append("\n");
        sb.append("    featureSpecRelationship: ").append(this.toIndentedString(this.featureSpecRelationship)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

