/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.JobStateType;
import org.springframework.validation.annotation.Validated;

@Schema(description="Represents a task used to export resources to a file")
@Validated
public class ExportJob {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="completionDate")
    private OffsetDateTime completionDate = null;
    @JsonProperty(value="contentType")
    private String contentType = null;
    @JsonProperty(value="creationDate")
    private OffsetDateTime creationDate = null;
    @JsonProperty(value="errorLog")
    private String errorLog = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="query")
    private String query = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="status")
    private JobStateType status = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ExportJob id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of the export job")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExportJob href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the export job")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ExportJob completionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Schema(description="Data at which the job was completed")
    @Valid
    public OffsetDateTime getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
    }

    public ExportJob contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Schema(description="The format of the exported data")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ExportJob creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Schema(description="Date at which the job was created")
    @Valid
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public ExportJob errorLog(String errorLog) {
        this.errorLog = errorLog;
        return this;
    }

    @Schema(description="Reason for failure")
    public String getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(String errorLog) {
        this.errorLog = errorLog;
    }

    public ExportJob path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="URL of the root resource acting as the source for streaming content to the file specified by the export job")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ExportJob query(String query) {
        this.query = query;
        return this;
    }

    @Schema(description="Used to scope the exported data")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ExportJob url(String url) {
        this.url = url;
        return this;
    }

    @Schema(description="URL of the file containing the data to be exported")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ExportJob status(JobStateType status) {
        this.status = status;
        return this;
    }

    @Schema(description="")
    @Valid
    public JobStateType getStatus() {
        return this.status;
    }

    public void setStatus(JobStateType status) {
        this.status = status;
    }

    public ExportJob _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ExportJob _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ExportJob _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportJob exportJob = (ExportJob)o;
        return Objects.equals(this.id, exportJob.id) && Objects.equals(this.href, exportJob.href) && Objects.equals(this.completionDate, exportJob.completionDate) && Objects.equals(this.contentType, exportJob.contentType) && Objects.equals(this.creationDate, exportJob.creationDate) && Objects.equals(this.errorLog, exportJob.errorLog) && Objects.equals(this.path, exportJob.path) && Objects.equals(this.query, exportJob.query) && Objects.equals(this.url, exportJob.url) && Objects.equals((Object)this.status, (Object)exportJob.status) && Objects.equals(this._atBaseType, exportJob._atBaseType) && Objects.equals(this._atSchemaLocation, exportJob._atSchemaLocation) && Objects.equals(this._atType, exportJob._atType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.href, this.completionDate, this.contentType, this.creationDate, this.errorLog, this.path, this.query, this.url, this.status, this._atBaseType, this._atSchemaLocation, this._atType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportJob {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    errorLog: ").append(this.toIndentedString(this.errorLog)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

