/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.rcm634.model.ConnectionPointSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="A specification for a vertex in a resource graph.")
@Validated
@Entity(name="EndpointSpecRef")
public class EndpointSpecificationRef
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="isRoot")
    private Boolean isRoot = true;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="connectionPointSpecification")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private ConnectionPointSpecificationRef connectionPointSpecification = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    public EndpointSpecificationRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="unique identifier")
    @NotNull
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public EndpointSpecificationRef href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public EndpointSpecificationRef isRoot(Boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    @Schema(description="Directionality: true when endpoint is a source, false when a sink. If true for all endpoints connectivity is bidirectional. Default is true.")
    public Boolean isIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
    }

    @Override
    public EndpointSpecificationRef name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the related entity.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public EndpointSpecificationRef role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="Role of the Resource Function.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public EndpointSpecificationRef connectionPointSpecification(ConnectionPointSpecificationRef connectionPointSpecification) {
        this.connectionPointSpecification = connectionPointSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public ConnectionPointSpecificationRef getConnectionPointSpecification() {
        return this.connectionPointSpecification;
    }

    public void setConnectionPointSpecification(ConnectionPointSpecificationRef connectionPointSpecification) {
        this.connectionPointSpecification = connectionPointSpecification;
    }

    public EndpointSpecificationRef _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointSpecificationRef endpointSpecificationRef = (EndpointSpecificationRef)o;
        return Objects.equals(this.id, endpointSpecificationRef.id) && Objects.equals(this.href, endpointSpecificationRef.href) && Objects.equals(this.isRoot, endpointSpecificationRef.isRoot) && Objects.equals(this.name, endpointSpecificationRef.name) && Objects.equals(this.role, endpointSpecificationRef.role) && Objects.equals(this.connectionPointSpecification, endpointSpecificationRef.connectionPointSpecification) && Objects.equals(this.baseType, endpointSpecificationRef.baseType) && Objects.equals(this.schemaLocation, endpointSpecificationRef.schemaLocation) && Objects.equals(this.type, endpointSpecificationRef.type) && Objects.equals(this._atReferredType, endpointSpecificationRef._atReferredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.isRoot, this.name, this.role, this.connectionPointSpecification, this.baseType, this.schemaLocation, this.type, this._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EndpointSpecificationRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    connectionPointSpecification: ").append(this.toIndentedString(this.connectionPointSpecification)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

