/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.rcm634.model.EndpointSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="A specification for an edge in a resource graph.")
@Validated
@Entity(name="ConnectionSpec")
public class ConnectionSpecification
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="associationType")
    private String associationType = null;
    @JsonProperty(value="endpointSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<EndpointSpecificationRef> endpointSpecification = new HashSet<EndpointSpecificationRef>();

    public ConnectionSpecification id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier for graph edge specification.")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ConnectionSpecification href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public ConnectionSpecification associationType(String associationType) {
        this.associationType = associationType;
        return this;
    }

    @Schema(description="Association type.")
    @NotNull
    public String getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    @Override
    public ConnectionSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Descriptive name for graph edge specification.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ConnectionSpecification endpointSpecification(Set<EndpointSpecificationRef> endpointSpecification) {
        this.endpointSpecification = endpointSpecification;
        return this;
    }

    public ConnectionSpecification addEndpointSpecificationItem(EndpointSpecificationRef endpointSpecificationItem) {
        this.endpointSpecification.add(endpointSpecificationItem);
        return this;
    }

    @Schema(description="Specifications for resource graph vertices connected by this edge.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) Set<EndpointSpecificationRef> getEndpointSpecification() {
        return this.endpointSpecification;
    }

    public void setEndpointSpecification(Set<EndpointSpecificationRef> endpointSpecification) {
        this.endpointSpecification = endpointSpecification;
    }

    public ConnectionSpecification _atBaseType(String _atBaseType) {
        this.baseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this.baseType = _atBaseType;
    }

    public ConnectionSpecification _atSchemaLocation(String _atSchemaLocation) {
        this.schemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this.schemaLocation = _atSchemaLocation;
    }

    public ConnectionSpecification _atType(String _atType) {
        this.type = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class Extensible name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String _atType) {
        this.type = _atType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionSpecification connectionSpecification = (ConnectionSpecification)o;
        return Objects.equals(this.id, connectionSpecification.id) && Objects.equals(this.href, connectionSpecification.href) && Objects.equals(this.associationType, connectionSpecification.associationType) && Objects.equals(this.name, connectionSpecification.name) && Objects.equals(this.endpointSpecification, connectionSpecification.endpointSpecification) && Objects.equals(this.baseType, connectionSpecification.baseType) && Objects.equals(this.schemaLocation, connectionSpecification.schemaLocation) && Objects.equals(this.type, connectionSpecification.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.associationType, this.name, this.endpointSpecification, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    associationType: ").append(this.toIndentedString(this.associationType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    endpointSpecification: ").append(this.toIndentedString(this.endpointSpecification)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

