/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Connection point specification reference. A connection point provides a service access point (SAP) for input and/or output of the resource function.")
@Validated
@Entity(name="ConnectionPointSpecRef")
public class ConnectionPointSpecificationRef
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    public ConnectionPointSpecificationRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="unique identifier")
    @NotNull
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ConnectionPointSpecificationRef href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public ConnectionPointSpecificationRef name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the related entity.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ConnectionPointSpecificationRef version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Connection point specification version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ConnectionPointSpecificationRef _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPointSpecificationRef connectionPointSpecificationRef = (ConnectionPointSpecificationRef)o;
        return Objects.equals(this.id, connectionPointSpecificationRef.id) && Objects.equals(this.href, connectionPointSpecificationRef.href) && Objects.equals(this.name, connectionPointSpecificationRef.name) && Objects.equals(this.version, connectionPointSpecificationRef.version) && Objects.equals(this.baseType, connectionPointSpecificationRef.baseType) && Objects.equals(this.schemaLocation, connectionPointSpecificationRef.schemaLocation) && Objects.equals(this.type, connectionPointSpecificationRef.type) && Objects.equals(this._atReferredType, connectionPointSpecificationRef._atReferredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.name, this.version, this.baseType, this.schemaLocation, this.type, this._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionPointSpecificationRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

