/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.prm669.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="RelatedParty reference. A related party defines party or party role linked to a specific entity.")
@Validated
@Entity(name="RelatedParty")
public class RelatedParty
extends BaseRootNamedEntity {
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="extendedInfo")
    private String extendedInfo = null;

    public RelatedParty() {
        this.baseType = "BaseRootEntity";
        this.type = this.getClass().getName();
    }

    public RelatedParty(RelatedParty rp) {
        this.name = rp.getName();
        this.role = rp.getRole();
        this.referredType = rp.getReferredType();
        this.id = rp.getId();
    }

    public RelatedParty id(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RelatedParty role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="Role of the related party.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public RelatedParty referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public String getExtendedInfo() {
        return this.extendedInfo;
    }

    public void setExtendedInfo(String extendedInfo) {
        this.extendedInfo = extendedInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedParty relatedParty = (RelatedParty)o;
        return Objects.equals(this.id, relatedParty.id) && Objects.equals(this.href, relatedParty.href) && Objects.equals(this.name, relatedParty.name) && Objects.equals(this.role, relatedParty.role) && Objects.equals(this.baseType, relatedParty.baseType) && Objects.equals(this.schemaLocation, relatedParty.schemaLocation) && Objects.equals(this.type, relatedParty.type) && Objects.equals(this.referredType, relatedParty.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedParty {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    extendedInfo: ").append(this.toIndentedString(this.extendedInfo)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

