/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.prm669.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="Describes the contact medium characteristics that could be used to contact a party (an individual or an organization)")
@Validated
public class MediumCharacteristic {
    @JsonProperty(value="city")
    private String city = null;
    @JsonProperty(value="contactType")
    private String contactType = null;
    @JsonProperty(value="country")
    private String country = null;
    @JsonProperty(value="emailAddress")
    private String emailAddress = null;
    @JsonProperty(value="faxNumber")
    private String faxNumber = null;
    @JsonProperty(value="phoneNumber")
    private String phoneNumber = null;
    @JsonProperty(value="postCode")
    private String postCode = null;
    @JsonProperty(value="socialNetworkId")
    private String socialNetworkId = null;
    @JsonProperty(value="stateOrProvince")
    private String stateOrProvince = null;
    @JsonProperty(value="street1")
    private String street1 = null;
    @JsonProperty(value="street2")
    private String street2 = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public MediumCharacteristic city(String city) {
        this.city = city;
        return this;
    }

    @Schema(description="The city")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public MediumCharacteristic contactType(String contactType) {
        this.contactType = contactType;
        return this;
    }

    @Schema(description="The type of contact, for example: phone number such as mobile, fixed home, fixed office. postal address such as shipping instalation\u2026")
    public String getContactType() {
        return this.contactType;
    }

    public void setContactType(String contactType) {
        this.contactType = contactType;
    }

    public MediumCharacteristic country(String country) {
        this.country = country;
        return this;
    }

    @Schema(description="The country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public MediumCharacteristic emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Schema(description="Full email address in standard format")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public MediumCharacteristic faxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
        return this;
    }

    @Schema(description="The fax number of the contact")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public MediumCharacteristic phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Schema(description="The primary phone number of the contact")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public MediumCharacteristic postCode(String postCode) {
        this.postCode = postCode;
        return this;
    }

    @Schema(description="Postcode")
    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public MediumCharacteristic socialNetworkId(String socialNetworkId) {
        this.socialNetworkId = socialNetworkId;
        return this;
    }

    @Schema(description="Identifier as a member of a social network")
    public String getSocialNetworkId() {
        return this.socialNetworkId;
    }

    public void setSocialNetworkId(String socialNetworkId) {
        this.socialNetworkId = socialNetworkId;
    }

    public MediumCharacteristic stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @Schema(description="State or province")
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public MediumCharacteristic street1(String street1) {
        this.street1 = street1;
        return this;
    }

    @Schema(description="Describes the street")
    public String getStreet1() {
        return this.street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    public MediumCharacteristic street2(String street2) {
        this.street2 = street2;
        return this;
    }

    @Schema(description="Complementary street description")
    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public MediumCharacteristic baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public MediumCharacteristic schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public MediumCharacteristic type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediumCharacteristic mediumCharacteristic = (MediumCharacteristic)o;
        return Objects.equals(this.city, mediumCharacteristic.city) && Objects.equals(this.contactType, mediumCharacteristic.contactType) && Objects.equals(this.country, mediumCharacteristic.country) && Objects.equals(this.emailAddress, mediumCharacteristic.emailAddress) && Objects.equals(this.faxNumber, mediumCharacteristic.faxNumber) && Objects.equals(this.phoneNumber, mediumCharacteristic.phoneNumber) && Objects.equals(this.postCode, mediumCharacteristic.postCode) && Objects.equals(this.socialNetworkId, mediumCharacteristic.socialNetworkId) && Objects.equals(this.stateOrProvince, mediumCharacteristic.stateOrProvince) && Objects.equals(this.street1, mediumCharacteristic.street1) && Objects.equals(this.street2, mediumCharacteristic.street2) && Objects.equals(this.baseType, mediumCharacteristic.baseType) && Objects.equals(this.schemaLocation, mediumCharacteristic.schemaLocation) && Objects.equals(this.type, mediumCharacteristic.type);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.contactType, this.country, this.emailAddress, this.faxNumber, this.phoneNumber, this.postCode, this.socialNetworkId, this.stateOrProvince, this.street1, this.street2, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediumCharacteristic {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    contactType: ").append(this.toIndentedString(this.contactType)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    faxNumber: ").append(this.toIndentedString(this.faxNumber)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    postCode: ").append(this.toIndentedString(this.postCode)).append("\n");
        sb.append("    socialNetworkId: ").append(this.toIndentedString(this.socialNetworkId)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    street1: ").append(this.toIndentedString(this.street1)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

