/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.prm669.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="Used when an API throws an Error, typically with a HTTP error response-code (3xx, 4xx, 5xx)")
@Validated
public class Error {
    @JsonProperty(value="code")
    private String code = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="referenceError")
    private String referenceError = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public Error code(String code) {
        this.code = code;
        return this;
    }

    @Schema(description="Application relevant detail, defined in the API or a common list.")
    @NotNull
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Error reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Schema(description="Explanation of the reason for the error which can be shown to a client user.")
    @NotNull
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @Schema(description="More details and corrective actions related to the error which can be shown to a client user.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="HTTP Error code extension")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Error referenceError(String referenceError) {
        this.referenceError = referenceError;
        return this;
    }

    @Schema(description="URI of documentation describing the error.")
    public String getReferenceError() {
        return this.referenceError;
    }

    public void setReferenceError(String referenceError) {
        this.referenceError = referenceError;
    }

    public Error baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class.")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public Error schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public Error type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.code, error.code) && Objects.equals(this.reason, error.reason) && Objects.equals(this.message, error.message) && Objects.equals(this.status, error.status) && Objects.equals(this.referenceError, error.referenceError) && Objects.equals(this.baseType, error.baseType) && Objects.equals(this.schemaLocation, error.schemaLocation) && Objects.equals(this.type, error.type);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.reason, this.message, this.status, this.referenceError, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    referenceError: ").append(this.toIndentedString(this.referenceError)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

