/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.prm669.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Credit profile for the party (containing credit scoring, ...). By default only the current credit profile  is retrieved. It can be used as a list to give the party credit profiles history, the first one in the list will be the current one.")
@Validated
public class CreditProfile {
    @JsonProperty(value="creditProfileDate")
    private OffsetDateTime creditProfileDate = null;
    @JsonProperty(value="creditRiskRating")
    private Integer creditRiskRating = null;
    @JsonProperty(value="creditScore")
    private Integer creditScore = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public CreditProfile creditProfileDate(OffsetDateTime creditProfileDate) {
        this.creditProfileDate = creditProfileDate;
        return this;
    }

    @Schema(description="The date the profile was established")
    @NotNull
    @Valid
    public OffsetDateTime getCreditProfileDate() {
        return this.creditProfileDate;
    }

    public void setCreditProfileDate(OffsetDateTime creditProfileDate) {
        this.creditProfileDate = creditProfileDate;
    }

    public CreditProfile creditRiskRating(Integer creditRiskRating) {
        this.creditRiskRating = creditRiskRating;
        return this;
    }

    @Schema(description="This is an integer whose value is used to rate the risk")
    public Integer getCreditRiskRating() {
        return this.creditRiskRating;
    }

    public void setCreditRiskRating(Integer creditRiskRating) {
        this.creditRiskRating = creditRiskRating;
    }

    public CreditProfile creditScore(Integer creditScore) {
        this.creditScore = creditScore;
        return this;
    }

    @Schema(description="A measure of a person or organizations creditworthiness calculated on the basis of a combination of factors such as their income and credit history")
    public Integer getCreditScore() {
        return this.creditScore;
    }

    public void setCreditScore(Integer creditScore) {
        this.creditScore = creditScore;
    }

    public CreditProfile validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the profile is valid")
    @NotNull
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public CreditProfile baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CreditProfile schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CreditProfile type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditProfile creditProfile = (CreditProfile)o;
        return Objects.equals(this.creditProfileDate, creditProfile.creditProfileDate) && Objects.equals(this.creditRiskRating, creditProfile.creditRiskRating) && Objects.equals(this.creditScore, creditProfile.creditScore) && Objects.equals(this.validFor, creditProfile.validFor) && Objects.equals(this.baseType, creditProfile.baseType) && Objects.equals(this.schemaLocation, creditProfile.schemaLocation) && Objects.equals(this.type, creditProfile.type);
    }

    public int hashCode() {
        return Objects.hash(this.creditProfileDate, this.creditRiskRating, this.creditScore, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditProfile {\n");
        sb.append("    creditProfileDate: ").append(this.toIndentedString(this.creditProfileDate)).append("\n");
        sb.append("    creditRiskRating: ").append(this.toIndentedString(this.creditRiskRating)).append("\n");
        sb.append("    creditScore: ").append(this.toIndentedString(this.creditScore)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

