/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.prm669.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.MediumCharacteristic;
import org.springframework.validation.annotation.Validated;

@Schema(description="Indicates the contact medium that could be used to contact the party.")
@Validated
public class ContactMedium {
    @JsonProperty(value="mediumType")
    private String mediumType = null;
    @JsonProperty(value="preferred")
    private Boolean preferred = null;
    @JsonProperty(value="characteristic")
    private MediumCharacteristic characteristic = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public ContactMedium mediumType(String mediumType) {
        this.mediumType = mediumType;
        return this;
    }

    @Schema(description="Type of the contact medium, such as: email address, telephone number, postal address")
    @NotNull
    public String getMediumType() {
        return this.mediumType;
    }

    public void setMediumType(String mediumType) {
        this.mediumType = mediumType;
    }

    public ContactMedium preferred(Boolean preferred) {
        this.preferred = preferred;
        return this;
    }

    @Schema(description="If true, indicates that is the preferred contact medium")
    public Boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(Boolean preferred) {
        this.preferred = preferred;
    }

    public ContactMedium characteristic(MediumCharacteristic characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    @Schema(description="Any additional characteristic(s) of this contact medium")
    @NotNull
    @Valid
    public MediumCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(MediumCharacteristic characteristic) {
        this.characteristic = characteristic;
    }

    public ContactMedium validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The time period that the contact medium is valid for")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ContactMedium baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ContactMedium schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ContactMedium type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactMedium contactMedium = (ContactMedium)o;
        return Objects.equals(this.mediumType, contactMedium.mediumType) && Objects.equals(this.preferred, contactMedium.preferred) && Objects.equals(this.characteristic, contactMedium.characteristic) && Objects.equals(this.validFor, contactMedium.validFor) && Objects.equals(this.baseType, contactMedium.baseType) && Objects.equals(this.schemaLocation, contactMedium.schemaLocation) && Objects.equals(this.type, contactMedium.type);
    }

    public int hashCode() {
        return Objects.hash(this.mediumType, this.preferred, this.characteristic, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactMedium {\n");
        sb.append("    mediumType: ").append(this.toIndentedString(this.mediumType)).append("\n");
        sb.append("    preferred: ").append(this.toIndentedString(this.preferred)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

