/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="RelatedProductOrderItem (ProductOrder item) .The product order item which triggered product creation/change/termination.")
@Validated
@Entity(name="RelatedProdOrdItem622")
public class RelatedProductOrderItem
extends BaseRootEntity {
    @JsonProperty(value="orderItemAction")
    private String orderItemAction = null;
    @JsonProperty(value="orderItemId")
    private String orderItemId = null;
    @JsonProperty(value="productOrderHref")
    private String productOrderHref = null;
    @JsonProperty(value="productOrderId")
    private String productOrderId = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    public RelatedProductOrderItem orderItemAction(String orderItemAction) {
        this.orderItemAction = orderItemAction;
        return this;
    }

    @Schema(description="Action of the order item for this product")
    public String getOrderItemAction() {
        return this.orderItemAction;
    }

    public void setOrderItemAction(String orderItemAction) {
        this.orderItemAction = orderItemAction;
    }

    public RelatedProductOrderItem orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @Schema(description="Identifier of the order item where the product was managed")
    @NotNull
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public RelatedProductOrderItem productOrderHref(String productOrderHref) {
        this.productOrderHref = productOrderHref;
        return this;
    }

    @Schema(description="Reference of the related entity.")
    public String getProductOrderHref() {
        return this.productOrderHref;
    }

    public void setProductOrderHref(String productOrderHref) {
        this.productOrderHref = productOrderHref;
    }

    public RelatedProductOrderItem productOrderId(String productOrderId) {
        this.productOrderId = productOrderId;
        return this;
    }

    @Schema(description="Unique identifier of a related entity.")
    @NotNull
    public String getProductOrderId() {
        return this.productOrderId;
    }

    public void setProductOrderId(String productOrderId) {
        this.productOrderId = productOrderId;
    }

    public RelatedProductOrderItem role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="role of the product order item for this product")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public RelatedProductOrderItem baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public RelatedProductOrderItem schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public RelatedProductOrderItem type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public RelatedProductOrderItem _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedProductOrderItem relatedProductOrderItem = (RelatedProductOrderItem)o;
        return Objects.equals(this.orderItemAction, relatedProductOrderItem.orderItemAction) && Objects.equals(this.orderItemId, relatedProductOrderItem.orderItemId) && Objects.equals(this.productOrderHref, relatedProductOrderItem.productOrderHref) && Objects.equals(this.productOrderId, relatedProductOrderItem.productOrderId) && Objects.equals(this.role, relatedProductOrderItem.role) && Objects.equals(this.baseType, relatedProductOrderItem.baseType) && Objects.equals(this.schemaLocation, relatedProductOrderItem.schemaLocation) && Objects.equals(this.type, relatedProductOrderItem.type) && Objects.equals(this._atReferredType, relatedProductOrderItem._atReferredType);
    }

    public int hashCode() {
        return Objects.hash(this.orderItemAction, this.orderItemId, this.productOrderHref, this.productOrderId, this.role, this.baseType, this.schemaLocation, this.type, this._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedProductOrderItem {\n");
        sb.append("    orderItemAction: ").append(this.toIndentedString(this.orderItemAction)).append("\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    productOrderHref: ").append(this.toIndentedString(this.productOrderHref)).append("\n");
        sb.append("    productOrderId: ").append(this.toIndentedString(this.productOrderId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

