/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.pim637.model.BillingAccountRef;
import org.etsi.osl.tmf.po622.model.AgreementRef;
import org.etsi.osl.tmf.po622.model.OrderPrice;
import org.etsi.osl.tmf.po622.model.PaymentRef;
import org.etsi.osl.tmf.po622.model.ProductOfferingQualificationRef;
import org.etsi.osl.tmf.po622.model.ProductOrderItem;
import org.etsi.osl.tmf.po622.model.ProductOrderStateType;
import org.etsi.osl.tmf.po622.model.QuoteRef;
import org.etsi.osl.tmf.po622.model.RelatedChannel;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Product Order is a type of order which  can  be used to place an order between a customer and a service provider or between a service provider and a partner and vice versa, Skipped properties: id,href,orderDate")
@Validated
public class ProductOrderUpdate {
    @JsonProperty(value="cancellationDate")
    private OffsetDateTime cancellationDate = null;
    @JsonProperty(value="cancellationReason")
    private String cancellationReason = null;
    @JsonProperty(value="category")
    private String category = null;
    private OffsetDateTime completionDate = null;
    @JsonProperty(value="description")
    private String description = null;
    private OffsetDateTime expectedCompletionDate = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="notificationContact")
    private String notificationContact = null;
    @JsonProperty(value="priority")
    private String priority = null;
    private OffsetDateTime requestedCompletionDate = null;
    private OffsetDateTime requestedStartDate = null;
    @JsonProperty(value="agreement")
    @Valid
    private List<AgreementRef> agreement = null;
    @JsonProperty(value="billingAccount")
    private BillingAccountRef billingAccount = null;
    @JsonProperty(value="channel")
    @Valid
    private List<RelatedChannel> channel = null;
    @JsonProperty(value="note")
    @Valid
    private List<Note> note = null;
    @JsonProperty(value="orderTotalPrice")
    @Valid
    private List<OrderPrice> orderTotalPrice = null;
    @JsonProperty(value="payment")
    @Valid
    private List<PaymentRef> payment = null;
    @JsonProperty(value="productOfferingQualification")
    @Valid
    private List<ProductOfferingQualificationRef> productOfferingQualification = null;
    @JsonProperty(value="productOrderItem")
    @Valid
    private List<ProductOrderItem> productOrderItem = new ArrayList<ProductOrderItem>();
    @JsonProperty(value="quote")
    @Valid
    private List<QuoteRef> quote = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="state")
    private ProductOrderStateType state = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public ProductOrderUpdate cancellationDate(OffsetDateTime cancellationDate) {
        this.cancellationDate = cancellationDate;
        return this;
    }

    @Schema(description="Date when the order is cancelled. This is used when order is cancelled. ")
    @Valid
    public OffsetDateTime getCancellationDate() {
        return this.cancellationDate;
    }

    public void setCancellationDate(OffsetDateTime cancellationDate) {
        this.cancellationDate = cancellationDate;
    }

    public ProductOrderUpdate cancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Schema(description="Reason why the order is cancelled. This is used when order is cancelled. ")
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public ProductOrderUpdate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Used to categorize the order from a business perspective that can be useful for the OM system (e.g. \"enterprise\", \"residential\", ...)")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ProductOrderUpdate completionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Schema(description="Date when the order was completed")
    @Valid
    public OffsetDateTime getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
    }

    public ProductOrderUpdate description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="completionDate")
    public String getCompletionDateStr() {
        if (this.completionDate != null) {
            return this.completionDate.toString();
        }
        return null;
    }

    public void setCompletionDate(String completionDate) {
        if (completionDate != null) {
            this.completionDate = OffsetDateTime.parse(completionDate);
        }
    }

    @Schema(description="Description of the product order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductOrderUpdate expectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
        return this;
    }

    @Schema(description="Expected delivery date amended by the provider")
    @Valid
    public OffsetDateTime getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    @JsonProperty(value="expectedCompletionDate")
    public String getExpectedCompletionDateStr() {
        if (this.expectedCompletionDate != null) {
            return this.expectedCompletionDate.toString();
        }
        return null;
    }

    public void setExpectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public void setExpectedCompletionDate(String expectedCompletionDate) {
        if (expectedCompletionDate != null) {
            this.expectedCompletionDate = OffsetDateTime.parse(expectedCompletionDate);
        }
    }

    public ProductOrderUpdate externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="ID given by the consumer and only understandable by him (to facilitate his searches afterwards)")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ProductOrderUpdate notificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
        return this;
    }

    @Schema(description="Contact attached to the order to send back information regarding this order")
    public String getNotificationContact() {
        return this.notificationContact;
    }

    public void setNotificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
    }

    public ProductOrderUpdate priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A way that can be used by consumers to prioritize orders in OM system (from 0 to 4 : 0 is the highest priority, and 4 the lowest)")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public ProductOrderUpdate requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    @JsonProperty(value="requestedCompletionDate")
    public String getRequestedCompletionDateStr() {
        if (this.requestedCompletionDate != null) {
            return this.requestedCompletionDate.toString();
        }
        return null;
    }

    public void setRequestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
    }

    @Schema(description="Requested delivery date from the requestor perspective")
    @Valid
    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public ProductOrderUpdate requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    @Schema(description="Order fulfillment start date wished by the requestor. This is used when, for any reason, requestor cannot allow seller to begin to operationally begin the fulfillment before a date. ")
    @Valid
    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    @JsonProperty(value="requestedStartDate")
    public String getRequestedStartDateStr() {
        if (this.requestedStartDate != null) {
            return this.requestedStartDate.toString();
        }
        return null;
    }

    public void setRequestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ProductOrderUpdate agreement(List<AgreementRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public ProductOrderUpdate addAgreementItem(AgreementRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new ArrayList<AgreementRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="A reference to an agreement defined in the context of the product order")
    @Valid
    public List<AgreementRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(List<AgreementRef> agreement) {
        this.agreement = agreement;
    }

    public ProductOrderUpdate billingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
        return this;
    }

    @Schema(description="")
    @Valid
    public BillingAccountRef getBillingAccount() {
        return this.billingAccount;
    }

    public void setBillingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
    }

    public ProductOrderUpdate channel(List<RelatedChannel> channel) {
        this.channel = channel;
        return this;
    }

    public ProductOrderUpdate addChannelItem(RelatedChannel channelItem) {
        if (this.channel == null) {
            this.channel = new ArrayList<RelatedChannel>();
        }
        this.channel.add(channelItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedChannel> getChannel() {
        return this.channel;
    }

    public void setChannel(List<RelatedChannel> channel) {
        this.channel = channel;
    }

    public ProductOrderUpdate note(List<Note> note) {
        this.note = note;
        return this;
    }

    public ProductOrderUpdate addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public ProductOrderUpdate orderTotalPrice(List<OrderPrice> orderTotalPrice) {
        this.orderTotalPrice = orderTotalPrice;
        return this;
    }

    public ProductOrderUpdate addOrderTotalPriceItem(OrderPrice orderTotalPriceItem) {
        if (this.orderTotalPrice == null) {
            this.orderTotalPrice = new ArrayList<OrderPrice>();
        }
        this.orderTotalPrice.add(orderTotalPriceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<OrderPrice> getOrderTotalPrice() {
        return this.orderTotalPrice;
    }

    public void setOrderTotalPrice(List<OrderPrice> orderTotalPrice) {
        this.orderTotalPrice = orderTotalPrice;
    }

    public ProductOrderUpdate payment(List<PaymentRef> payment) {
        this.payment = payment;
        return this;
    }

    public ProductOrderUpdate addPaymentItem(PaymentRef paymentItem) {
        if (this.payment == null) {
            this.payment = new ArrayList<PaymentRef>();
        }
        this.payment.add(paymentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<PaymentRef> getPayment() {
        return this.payment;
    }

    public void setPayment(List<PaymentRef> payment) {
        this.payment = payment;
    }

    public ProductOrderUpdate productOfferingQualification(List<ProductOfferingQualificationRef> productOfferingQualification) {
        this.productOfferingQualification = productOfferingQualification;
        return this;
    }

    public ProductOrderUpdate addProductOfferingQualificationItem(ProductOfferingQualificationRef productOfferingQualificationItem) {
        if (this.productOfferingQualification == null) {
            this.productOfferingQualification = new ArrayList<ProductOfferingQualificationRef>();
        }
        this.productOfferingQualification.add(productOfferingQualificationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ProductOfferingQualificationRef> getProductOfferingQualification() {
        return this.productOfferingQualification;
    }

    public void setProductOfferingQualification(List<ProductOfferingQualificationRef> productOfferingQualification) {
        this.productOfferingQualification = productOfferingQualification;
    }

    public ProductOrderUpdate productOrderItem(List<ProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
        return this;
    }

    public ProductOrderUpdate addProductOrderItemItem(ProductOrderItem productOrderItemItem) {
        this.productOrderItem.add(productOrderItemItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<ProductOrderItem> getProductOrderItem() {
        return this.productOrderItem;
    }

    public void setProductOrderItem(List<ProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
    }

    public ProductOrderUpdate quote(List<QuoteRef> quote) {
        this.quote = quote;
        return this;
    }

    public ProductOrderUpdate addQuoteItem(QuoteRef quoteItem) {
        if (this.quote == null) {
            this.quote = new ArrayList<QuoteRef>();
        }
        this.quote.add(quoteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<QuoteRef> getQuote() {
        return this.quote;
    }

    public void setQuote(List<QuoteRef> quote) {
        this.quote = quote;
    }

    public ProductOrderUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ProductOrderUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ProductOrderUpdate state(ProductOrderStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="")
    @Valid
    public ProductOrderStateType getState() {
        return this.state;
    }

    public void setState(ProductOrderStateType state) {
        this.state = state;
    }

    public ProductOrderUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ProductOrderUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ProductOrderUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOrderUpdate productOrderUpdate = (ProductOrderUpdate)o;
        return Objects.equals(this.cancellationDate, productOrderUpdate.cancellationDate) && Objects.equals(this.cancellationReason, productOrderUpdate.cancellationReason) && Objects.equals(this.category, productOrderUpdate.category) && Objects.equals(this.completionDate, productOrderUpdate.completionDate) && Objects.equals(this.description, productOrderUpdate.description) && Objects.equals(this.expectedCompletionDate, productOrderUpdate.expectedCompletionDate) && Objects.equals(this.externalId, productOrderUpdate.externalId) && Objects.equals(this.notificationContact, productOrderUpdate.notificationContact) && Objects.equals(this.priority, productOrderUpdate.priority) && Objects.equals(this.requestedCompletionDate, productOrderUpdate.requestedCompletionDate) && Objects.equals(this.requestedStartDate, productOrderUpdate.requestedStartDate) && Objects.equals(this.agreement, productOrderUpdate.agreement) && Objects.equals(this.billingAccount, productOrderUpdate.billingAccount) && Objects.equals(this.channel, productOrderUpdate.channel) && Objects.equals(this.note, productOrderUpdate.note) && Objects.equals(this.orderTotalPrice, productOrderUpdate.orderTotalPrice) && Objects.equals(this.payment, productOrderUpdate.payment) && Objects.equals(this.productOfferingQualification, productOrderUpdate.productOfferingQualification) && Objects.equals(this.productOrderItem, productOrderUpdate.productOrderItem) && Objects.equals(this.quote, productOrderUpdate.quote) && Objects.equals(this.relatedParty, productOrderUpdate.relatedParty) && Objects.equals((Object)this.state, (Object)productOrderUpdate.state) && Objects.equals(this.baseType, productOrderUpdate.baseType) && Objects.equals(this.schemaLocation, productOrderUpdate.schemaLocation) && Objects.equals(this.type, productOrderUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cancellationDate, this.cancellationReason, this.category, this.completionDate, this.description, this.expectedCompletionDate, this.externalId, this.notificationContact, this.priority, this.requestedCompletionDate, this.requestedStartDate, this.agreement, this.billingAccount, this.channel, this.note, this.orderTotalPrice, this.payment, this.productOfferingQualification, this.productOrderItem, this.quote, this.relatedParty, this.state, this.baseType, this.schemaLocation, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOrderUpdate {\n");
        sb.append("    cancellationDate: ").append(this.toIndentedString(this.cancellationDate)).append("\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString(this.cancellationReason)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expectedCompletionDate: ").append(this.toIndentedString(this.expectedCompletionDate)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    notificationContact: ").append(this.toIndentedString(this.notificationContact)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    billingAccount: ").append(this.toIndentedString(this.billingAccount)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderTotalPrice: ").append(this.toIndentedString(this.orderTotalPrice)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    productOfferingQualification: ").append(this.toIndentedString(this.productOfferingQualification)).append("\n");
        sb.append("    productOrderItem: ").append(this.toIndentedString(this.productOrderItem)).append("\n");
        sb.append("    quote: ").append(this.toIndentedString(this.quote)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

