/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import java.util.Set;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.po622.model.OrderItemActionType;
import org.etsi.osl.tmf.po622.model.ProductOrder;
import org.etsi.osl.tmf.po622.model.ProductOrderItem;
import org.etsi.osl.tmf.po622.model.ProductOrderItemStateType;
import org.etsi.osl.tmf.po622.model.ProductOrderStateType;
import org.etsi.osl.tmf.po622.model.ProductOrderUpdate;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.NullValueMappingStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;

@Mapper(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS)
public interface ProductOrderMapper {
    @Mappings(value={@Mapping(target="orderDate", ignore=true), @Mapping(target="uuid", ignore=true), @Mapping(target="baseType", ignore=true), @Mapping(target="href", ignore=true), @Mapping(target="schemaLocation", ignore=true), @Mapping(target="type", ignore=true)})
    public ProductOrder fromProductOrderUpdate(ProductOrderUpdate var1);

    @Mappings(value={@Mapping(target="baseType", ignore=true), @Mapping(target="schemaLocation", ignore=true), @Mapping(target="href", ignore=true), @Mapping(target="type", ignore=true), @Mapping(target="uuid", ignore=true), @Mapping(target="productOrderItem", expression="java(updateProductOrderItem(entity, updateEntity))"), @Mapping(target="note", expression="java(updateNote(entity, updateEntity))"), @Mapping(target="relatedParty", expression="java(updateRelatedParty(entity, updateEntity))")})
    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
    public ProductOrder updateProductOrder(@MappingTarget ProductOrder var1, ProductOrderUpdate var2);

    default public Set<ProductOrderItem> updateProductOrderItem(ProductOrder so, ProductOrderUpdate updateEntity) {
        if (updateEntity.getProductOrderItem() != null) {
            for (ProductOrderItem soiUpd : updateEntity.getProductOrderItem()) {
                ProductOrderItem soiOrigin = so.findOrderItemById(soiUpd.getId());
                if (soiOrigin != null) {
                    if (!(soiOrigin = this.updateOrderItem(soiOrigin, soiUpd)).getAction().equals((Object)OrderItemActionType.MODIFY) && !soiOrigin.getAction().equals((Object)OrderItemActionType.DELETE)) continue;
                    soiOrigin.setState(ProductOrderItemStateType.ACKNOWLEDGED);
                    so.setState(ProductOrderStateType.ACKNOWLEDGED);
                    continue;
                }
                so.addProductOrderItemItem(soiUpd);
            }
        }
        return so.getProductOrderItem();
    }

    default public ProductOrderItem updateOrderItem(ProductOrderItem soi, ProductOrderItem soiUpd) {
        ProductOrderItem soiOrigin = soi;
        if (soiUpd.getAction() != null) {
            soiOrigin.setAction(soiUpd.getAction());
        }
        if (soiUpd.getProductOffering() != null) {
            soiOrigin.setProductOffering(soiUpd.getProductOffering());
        }
        if (soiUpd.getProduct() != null) {
            if (soiOrigin.getProduct() == null) {
                soiOrigin.setProduct(soiUpd.getProduct());
            } else {
                soiOrigin.getProduct().setStatus(soiUpd.getProduct().getStatus());
                soiOrigin.getProduct().setName(soiUpd.getProduct().getName());
                for (Characteristic updChar : soiUpd.getProduct().getProductCharacteristic()) {
                    String charname = updChar.getName();
                    Characteristic originChar = soiOrigin.getProduct().findCharacteristicByName(charname);
                    if (originChar != null && updChar != null && originChar.getValue() != null && originChar.getValue().getValue() != null && updChar.getValue() != null) {
                        if (originChar.getValue().getValue().equals(updChar.getValue().getValue())) continue;
                        originChar.setValue(new Any(updChar.getValue()));
                        continue;
                    }
                    if (originChar == null || originChar.getValue() != null || updChar.getValue() == null) continue;
                    originChar.setValue(new Any(updChar.getValue()));
                }
                for (ServiceRef serviceRef : soiUpd.getProduct().getRealizingService()) {
                    if (soiOrigin.getProduct().getRealizingServiceById(serviceRef.getId()) != null) continue;
                    soiOrigin.getProduct().addRealizingServiceItem(serviceRef);
                }
                for (ResourceRef resourceRef : soiUpd.getProduct().getRealizingResource()) {
                    if (soiOrigin.getProduct().getRealizingResourceById(resourceRef.getId()) != null) continue;
                    soiOrigin.getProduct().addRealizingResourceItem(resourceRef);
                }
            }
        }
        return soiOrigin;
    }

    default public Set<Note> updateNote(ProductOrder so, ProductOrderUpdate updateEntity) {
        if (updateEntity.getNote() != null) {
            for (Note n : updateEntity.getNote()) {
                if (n.getUuid() != null) continue;
                so.addNoteItem(n);
            }
        }
        return so.getNote();
    }

    default public Set<RelatedParty> updateRelatedParty(ProductOrder so, ProductOrderUpdate updateEntity) {
        if (updateEntity.getRelatedParty() != null) {
            for (RelatedParty n : updateEntity.getRelatedParty()) {
                if (n.getUuid() != null) continue;
                so.addRelatedPartyItem(n);
            }
        }
        return so.getRelatedParty();
    }
}

