/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingRef;
import org.etsi.osl.tmf.pim637.model.BillingAccountRef;
import org.etsi.osl.tmf.pim637.model.ProductRefOrValue;
import org.etsi.osl.tmf.po622.model.AppointmentRef;
import org.etsi.osl.tmf.po622.model.OrderItemActionType;
import org.etsi.osl.tmf.po622.model.OrderItemRelationship;
import org.etsi.osl.tmf.po622.model.OrderPrice;
import org.etsi.osl.tmf.po622.model.OrderTerm;
import org.etsi.osl.tmf.po622.model.PaymentRef;
import org.etsi.osl.tmf.po622.model.ProductOfferingQualificationItemRef;
import org.etsi.osl.tmf.po622.model.ProductOfferingQualificationRef;
import org.etsi.osl.tmf.po622.model.ProductOrderItemStateType;
import org.etsi.osl.tmf.po622.model.QuoteItemRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="An identified part of the order. A product order is decomposed into one or more order items.")
@Validated
@Entity(name="POItem622")
public class ProductOrderItem
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="quantity")
    private Integer quantity = null;
    @JsonProperty(value="action")
    private OrderItemActionType action = null;
    @JsonProperty(value="appointment")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="appoint_refuuid", referencedColumnName="uuid")
    private AppointmentRef appointment = null;
    @JsonProperty(value="billingAccount")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="billing_acc_refuuid", referencedColumnName="uuid")
    private BillingAccountRef billingAccount = null;
    @JsonProperty(value="itemPrice")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OrderPrice> itemPrice = new HashSet<OrderPrice>();
    @JsonProperty(value="itemTerm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OrderTerm> itemTerm = new HashSet<OrderTerm>();
    @JsonProperty(value="itemTotalPrice")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OrderPrice> itemTotalPrice = new HashSet<OrderPrice>();
    @JsonProperty(value="payment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PaymentRef> payment = new HashSet<PaymentRef>();
    @JsonProperty(value="product")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="prod_refuuid", referencedColumnName="uuid")
    private ProductRefOrValue product = null;
    @JsonProperty(value="productOffering")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="prodoff_refuuid", referencedColumnName="uuid")
    private ProductOfferingRef productOffering = null;
    @JsonProperty(value="productOfferingQualificationItem")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="prodoffqual_refuuid", referencedColumnName="uuid")
    private ProductOfferingQualificationItemRef productOfferingQualificationItem = null;
    @JsonProperty(value="productOrderItem")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductOrderItem> productOrderItem = new HashSet<ProductOrderItem>();
    @JsonProperty(value="productOrderItemRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OrderItemRelationship> productOrderItemRelationship = new HashSet<OrderItemRelationship>();
    @JsonProperty(value="qualification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductOfferingQualificationRef> qualification = new HashSet<ProductOfferingQualificationRef>();
    @JsonProperty(value="quoteItem")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="qitem_refuuid", referencedColumnName="uuid")
    private QuoteItemRef quoteItem = null;
    @JsonProperty(value="state")
    private ProductOrderItemStateType state = ProductOrderItemStateType.INITIAL;

    @Schema(description="Identifier of the line item (generally it is a sequence number 01, 02, 03, ...)")
    @NotNull
    public String getId() {
        return this.uuid;
    }

    public ProductOrderItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="Quantity ordered")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public ProductOrderItem action(OrderItemActionType action) {
        this.action = action;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public OrderItemActionType getAction() {
        return this.action;
    }

    public void setAction(OrderItemActionType action) {
        this.action = action;
    }

    public ProductOrderItem appointment(AppointmentRef appointment) {
        this.appointment = appointment;
        return this;
    }

    @Schema(description="")
    @Valid
    public AppointmentRef getAppointment() {
        return this.appointment;
    }

    public void setAppointment(AppointmentRef appointment) {
        this.appointment = appointment;
    }

    public ProductOrderItem billingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
        return this;
    }

    @Schema(description="")
    @Valid
    public BillingAccountRef getBillingAccount() {
        return this.billingAccount;
    }

    public void setBillingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
    }

    public ProductOrderItem itemPrice(Set<OrderPrice> itemPrice) {
        this.itemPrice = itemPrice;
        return this;
    }

    public ProductOrderItem addItemPriceItem(OrderPrice itemPriceItem) {
        if (this.itemPrice == null) {
            this.itemPrice = new HashSet<OrderPrice>();
        }
        this.itemPrice.add(itemPriceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OrderPrice> getItemPrice() {
        return this.itemPrice;
    }

    public void setItemPrice(Set<OrderPrice> itemPrice) {
        this.itemPrice = itemPrice;
    }

    public ProductOrderItem itemTerm(Set<OrderTerm> itemTerm) {
        this.itemTerm = itemTerm;
        return this;
    }

    public ProductOrderItem addItemTermItem(OrderTerm itemTermItem) {
        if (this.itemTerm == null) {
            this.itemTerm = new HashSet<OrderTerm>();
        }
        this.itemTerm.add(itemTermItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OrderTerm> getItemTerm() {
        return this.itemTerm;
    }

    public void setItemTerm(Set<OrderTerm> itemTerm) {
        this.itemTerm = itemTerm;
    }

    public ProductOrderItem itemTotalPrice(Set<OrderPrice> itemTotalPrice) {
        this.itemTotalPrice = itemTotalPrice;
        return this;
    }

    public ProductOrderItem addItemTotalPriceItem(OrderPrice itemTotalPriceItem) {
        if (this.itemTotalPrice == null) {
            this.itemTotalPrice = new HashSet<OrderPrice>();
        }
        this.itemTotalPrice.add(itemTotalPriceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OrderPrice> getItemTotalPrice() {
        return this.itemTotalPrice;
    }

    public void setItemTotalPrice(Set<OrderPrice> itemTotalPrice) {
        this.itemTotalPrice = itemTotalPrice;
    }

    public ProductOrderItem payment(Set<PaymentRef> payment) {
        this.payment = payment;
        return this;
    }

    public ProductOrderItem addPaymentItem(PaymentRef paymentItem) {
        if (this.payment == null) {
            this.payment = new HashSet<PaymentRef>();
        }
        this.payment.add(paymentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<PaymentRef> getPayment() {
        return this.payment;
    }

    public void setPayment(Set<PaymentRef> payment) {
        this.payment = payment;
    }

    public ProductOrderItem product(ProductRefOrValue product) {
        this.product = product;
        return this;
    }

    @Schema(description="")
    @Valid
    public ProductRefOrValue getProduct() {
        return this.product;
    }

    public void setProduct(ProductRefOrValue product) {
        this.product = product;
    }

    public ProductOrderItem productOffering(ProductOfferingRef productOffering) {
        this.productOffering = productOffering;
        return this;
    }

    @Schema(description="")
    @Valid
    public ProductOfferingRef getProductOffering() {
        return this.productOffering;
    }

    public void setProductOffering(ProductOfferingRef productOffering) {
        this.productOffering = productOffering;
    }

    public ProductOrderItem productOfferingQualificationItem(ProductOfferingQualificationItemRef productOfferingQualificationItem) {
        this.productOfferingQualificationItem = productOfferingQualificationItem;
        return this;
    }

    @Schema(description="")
    @Valid
    public ProductOfferingQualificationItemRef getProductOfferingQualificationItem() {
        return this.productOfferingQualificationItem;
    }

    public void setProductOfferingQualificationItem(ProductOfferingQualificationItemRef productOfferingQualificationItem) {
        this.productOfferingQualificationItem = productOfferingQualificationItem;
    }

    public ProductOrderItem productOrderItem(Set<ProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
        return this;
    }

    public ProductOrderItem addProductOrderItemItem(ProductOrderItem productOrderItemItem) {
        this.productOrderItem.add(productOrderItemItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ProductOrderItem> getProductOrderItem() {
        return this.productOrderItem;
    }

    public void setProductOrderItem(Set<ProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
    }

    public ProductOrderItem productOrderItemRelationship(Set<OrderItemRelationship> productOrderItemRelationship) {
        this.productOrderItemRelationship = productOrderItemRelationship;
        return this;
    }

    public ProductOrderItem addProductOrderItemRelationshipItem(OrderItemRelationship productOrderItemRelationshipItem) {
        if (this.productOrderItemRelationship == null) {
            this.productOrderItemRelationship = new HashSet<OrderItemRelationship>();
        }
        this.productOrderItemRelationship.add(productOrderItemRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OrderItemRelationship> getProductOrderItemRelationship() {
        return this.productOrderItemRelationship;
    }

    public void setProductOrderItemRelationship(Set<OrderItemRelationship> productOrderItemRelationship) {
        this.productOrderItemRelationship = productOrderItemRelationship;
    }

    public ProductOrderItem qualification(Set<ProductOfferingQualificationRef> qualification) {
        this.qualification = qualification;
        return this;
    }

    public ProductOrderItem addQualificationItem(ProductOfferingQualificationRef qualificationItem) {
        if (this.qualification == null) {
            this.qualification = new HashSet<ProductOfferingQualificationRef>();
        }
        this.qualification.add(qualificationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ProductOfferingQualificationRef> getQualification() {
        return this.qualification;
    }

    public void setQualification(Set<ProductOfferingQualificationRef> qualification) {
        this.qualification = qualification;
    }

    public ProductOrderItem quoteItem(QuoteItemRef quoteItem) {
        this.quoteItem = quoteItem;
        return this;
    }

    @Schema(description="")
    @Valid
    public QuoteItemRef getQuoteItem() {
        return this.quoteItem;
    }

    public void setQuoteItem(QuoteItemRef quoteItem) {
        this.quoteItem = quoteItem;
    }

    public ProductOrderItem state(ProductOrderItemStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="")
    @Valid
    public ProductOrderItemStateType getState() {
        return this.state;
    }

    public void setState(ProductOrderItemStateType state) {
        this.state = state;
    }

    @Override
    public ProductOrderItem baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public ProductOrderItem schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ProductOrderItem type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOrderItem productOrderItem = (ProductOrderItem)o;
        return Objects.equals(this.id, productOrderItem.id) && Objects.equals(this.quantity, productOrderItem.quantity) && Objects.equals((Object)this.action, (Object)productOrderItem.action) && Objects.equals(this.appointment, productOrderItem.appointment) && Objects.equals(this.billingAccount, productOrderItem.billingAccount) && Objects.equals(this.itemPrice, productOrderItem.itemPrice) && Objects.equals(this.itemTerm, productOrderItem.itemTerm) && Objects.equals(this.itemTotalPrice, productOrderItem.itemTotalPrice) && Objects.equals(this.payment, productOrderItem.payment) && Objects.equals(this.product, productOrderItem.product) && Objects.equals(this.productOffering, productOrderItem.productOffering) && Objects.equals(this.productOfferingQualificationItem, productOrderItem.productOfferingQualificationItem) && Objects.equals(this.productOrderItem, productOrderItem.productOrderItem) && Objects.equals(this.productOrderItemRelationship, productOrderItem.productOrderItemRelationship) && Objects.equals(this.qualification, productOrderItem.qualification) && Objects.equals(this.quoteItem, productOrderItem.quoteItem) && Objects.equals((Object)this.state, (Object)productOrderItem.state) && Objects.equals(this.baseType, productOrderItem.baseType) && Objects.equals(this.schemaLocation, productOrderItem.schemaLocation) && Objects.equals(this.type, productOrderItem.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.quantity, this.action, this.appointment, this.billingAccount, this.itemPrice, this.itemTerm, this.itemTotalPrice, this.payment, this.product, this.productOffering, this.productOfferingQualificationItem, this.productOrderItem, this.productOrderItemRelationship, this.qualification, this.quoteItem, this.state, this.baseType, this.schemaLocation, this.type});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOrderItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    appointment: ").append(this.toIndentedString(this.appointment)).append("\n");
        sb.append("    billingAccount: ").append(this.toIndentedString(this.billingAccount)).append("\n");
        sb.append("    itemPrice: ").append(this.toIndentedString(this.itemPrice)).append("\n");
        sb.append("    itemTerm: ").append(this.toIndentedString(this.itemTerm)).append("\n");
        sb.append("    itemTotalPrice: ").append(this.toIndentedString(this.itemTotalPrice)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    productOffering: ").append(this.toIndentedString(this.productOffering)).append("\n");
        sb.append("    productOfferingQualificationItem: ").append(this.toIndentedString(this.productOfferingQualificationItem)).append("\n");
        sb.append("    productOrderItem: ").append(this.toIndentedString(this.productOrderItem)).append("\n");
        sb.append("    productOrderItemRelationship: ").append(this.toIndentedString(this.productOrderItemRelationship)).append("\n");
        sb.append("    qualification: ").append(this.toIndentedString(this.qualification)).append("\n");
        sb.append("    quoteItem: ").append(this.toIndentedString(this.quoteItem)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

