/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.pim637.model.BillingAccountRef;
import org.etsi.osl.tmf.po622.model.AgreementRef;
import org.etsi.osl.tmf.po622.model.OrderPrice;
import org.etsi.osl.tmf.po622.model.PaymentRef;
import org.etsi.osl.tmf.po622.model.ProductOfferingQualificationRef;
import org.etsi.osl.tmf.po622.model.ProductOrderItem;
import org.etsi.osl.tmf.po622.model.ProductOrderStateType;
import org.etsi.osl.tmf.po622.model.QuoteRef;
import org.etsi.osl.tmf.po622.model.RelatedChannel;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Product Order is a type of order which  can  be used to place an order between a customer and a service provider or between a service provider and a partner and vice versa, Skipped properties: id,href,completionDate,orderDate,state,expectedCompletionDate,productOrderItem.state")
@Validated
public class ProductOrderCreate {
    @JsonProperty(value="cancellationDate")
    private OffsetDateTime cancellationDate = null;
    @JsonProperty(value="cancellationReason")
    private String cancellationReason = null;
    @JsonProperty(value="category")
    private String category = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="notificationContact")
    private String notificationContact = null;
    @JsonProperty(value="priority")
    private String priority = null;
    private OffsetDateTime requestedCompletionDate = null;
    private OffsetDateTime requestedStartDate = null;
    @JsonProperty(value="agreement")
    @Valid
    private List<AgreementRef> agreement = null;
    @JsonProperty(value="billingAccount")
    private BillingAccountRef billingAccount = null;
    @JsonProperty(value="channel")
    @Valid
    private List<RelatedChannel> channel = null;
    @JsonProperty(value="note")
    @Valid
    private List<Note> note = null;
    @JsonProperty(value="orderTotalPrice")
    @Valid
    private List<OrderPrice> orderTotalPrice = null;
    @JsonProperty(value="payment")
    @Valid
    private List<PaymentRef> payment = null;
    @JsonProperty(value="productOfferingQualification")
    @Valid
    private List<ProductOfferingQualificationRef> productOfferingQualification = null;
    @JsonProperty(value="productOrderItem")
    @Valid
    private List<ProductOrderItem> productOrderItem = new ArrayList<ProductOrderItem>();
    @JsonProperty(value="quote")
    @Valid
    private List<QuoteRef> quote = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="state")
    private ProductOrderStateType state = null;

    public ProductOrderCreate cancellationDate(OffsetDateTime cancellationDate) {
        this.cancellationDate = cancellationDate;
        return this;
    }

    @Schema(description="Date when the order is cancelled. This is used when order is cancelled. ")
    @Valid
    public OffsetDateTime getCancellationDate() {
        return this.cancellationDate;
    }

    public void setCancellationDate(OffsetDateTime cancellationDate) {
        this.cancellationDate = cancellationDate;
    }

    public ProductOrderCreate cancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Schema(description="Reason why the order is cancelled. This is used when order is cancelled. ")
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public ProductOrderCreate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Used to categorize the order from a business perspective that can be useful for the OM system (e.g. \"enterprise\", \"residential\", ...)")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ProductOrderCreate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the product order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductOrderCreate externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="ID given by the consumer and only understandable by him (to facilitate his searches afterwards)")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ProductOrderCreate notificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
        return this;
    }

    @Schema(description="Contact attached to the order to send back information regarding this order")
    public String getNotificationContact() {
        return this.notificationContact;
    }

    public void setNotificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
    }

    public ProductOrderCreate priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A way that can be used by consumers to prioritize orders in OM system (from 0 to 4 : 0 is the highest priority, and 4 the lowest)")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public ProductOrderCreate requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    @Schema(description="Requested delivery date from the requestor perspective")
    @Valid
    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    @JsonProperty(value="requestedCompletionDate")
    public String getRequestedCompletionDateStr() {
        if (this.requestedCompletionDate != null) {
            return this.requestedCompletionDate.toString();
        }
        return null;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public void setRequestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
    }

    public ProductOrderCreate requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    @Schema(description="Order fulfillment start date wished by the requestor. This is used when, for any reason, requestor cannot allow seller to begin to operationally begin the fulfillment before a date. ")
    @Valid
    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    public void setRequestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    @JsonProperty(value="requestedStartDate")
    public String getRequestedStartDateStr() {
        if (this.requestedStartDate != null) {
            return this.requestedStartDate.toString();
        }
        return null;
    }

    public ProductOrderCreate agreement(List<AgreementRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public ProductOrderCreate addAgreementItem(AgreementRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new ArrayList<AgreementRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="A reference to an agreement defined in the context of the product order")
    @Valid
    public List<AgreementRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(List<AgreementRef> agreement) {
        this.agreement = agreement;
    }

    public ProductOrderCreate billingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
        return this;
    }

    @Schema(description="")
    @Valid
    public BillingAccountRef getBillingAccount() {
        return this.billingAccount;
    }

    public void setBillingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
    }

    public ProductOrderCreate channel(List<RelatedChannel> channel) {
        this.channel = channel;
        return this;
    }

    public ProductOrderCreate addChannelItem(RelatedChannel channelItem) {
        if (this.channel == null) {
            this.channel = new ArrayList<RelatedChannel>();
        }
        this.channel.add(channelItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedChannel> getChannel() {
        return this.channel;
    }

    public void setChannel(List<RelatedChannel> channel) {
        this.channel = channel;
    }

    public ProductOrderCreate note(List<Note> note) {
        this.note = note;
        return this;
    }

    public ProductOrderCreate addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public ProductOrderCreate orderTotalPrice(List<OrderPrice> orderTotalPrice) {
        this.orderTotalPrice = orderTotalPrice;
        return this;
    }

    public ProductOrderCreate addOrderTotalPriceItem(OrderPrice orderTotalPriceItem) {
        if (this.orderTotalPrice == null) {
            this.orderTotalPrice = new ArrayList<OrderPrice>();
        }
        this.orderTotalPrice.add(orderTotalPriceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<OrderPrice> getOrderTotalPrice() {
        return this.orderTotalPrice;
    }

    public void setOrderTotalPrice(List<OrderPrice> orderTotalPrice) {
        this.orderTotalPrice = orderTotalPrice;
    }

    public ProductOrderCreate payment(List<PaymentRef> payment) {
        this.payment = payment;
        return this;
    }

    public ProductOrderCreate addPaymentItem(PaymentRef paymentItem) {
        if (this.payment == null) {
            this.payment = new ArrayList<PaymentRef>();
        }
        this.payment.add(paymentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<PaymentRef> getPayment() {
        return this.payment;
    }

    public void setPayment(List<PaymentRef> payment) {
        this.payment = payment;
    }

    public ProductOrderCreate productOfferingQualification(List<ProductOfferingQualificationRef> productOfferingQualification) {
        this.productOfferingQualification = productOfferingQualification;
        return this;
    }

    public ProductOrderCreate addProductOfferingQualificationItem(ProductOfferingQualificationRef productOfferingQualificationItem) {
        if (this.productOfferingQualification == null) {
            this.productOfferingQualification = new ArrayList<ProductOfferingQualificationRef>();
        }
        this.productOfferingQualification.add(productOfferingQualificationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ProductOfferingQualificationRef> getProductOfferingQualification() {
        return this.productOfferingQualification;
    }

    public void setProductOfferingQualification(List<ProductOfferingQualificationRef> productOfferingQualification) {
        this.productOfferingQualification = productOfferingQualification;
    }

    public ProductOrderCreate productOrderItem(List<ProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
        return this;
    }

    public ProductOrderCreate addProductOrderItemItem(ProductOrderItem productOrderItemItem) {
        this.productOrderItem.add(productOrderItemItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<ProductOrderItem> getProductOrderItem() {
        return this.productOrderItem;
    }

    public void setProductOrderItem(List<ProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
    }

    public ProductOrderCreate quote(List<QuoteRef> quote) {
        this.quote = quote;
        return this;
    }

    public ProductOrderCreate addQuoteItem(QuoteRef quoteItem) {
        if (this.quote == null) {
            this.quote = new ArrayList<QuoteRef>();
        }
        this.quote.add(quoteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<QuoteRef> getQuote() {
        return this.quote;
    }

    public void setQuote(List<QuoteRef> quote) {
        this.quote = quote;
    }

    public ProductOrderCreate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ProductOrderCreate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ProductOrderCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ProductOrderCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ProductOrderCreate state(ProductOrderStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="")
    @Valid
    public ProductOrderStateType getState() {
        return this.state;
    }

    public void setState(ProductOrderStateType state) {
        this.state = state;
    }

    public ProductOrderCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOrderCreate productOrderCreate = (ProductOrderCreate)o;
        return Objects.equals(this.cancellationDate, productOrderCreate.cancellationDate) && Objects.equals(this.cancellationReason, productOrderCreate.cancellationReason) && Objects.equals(this.category, productOrderCreate.category) && Objects.equals(this.description, productOrderCreate.description) && Objects.equals(this.externalId, productOrderCreate.externalId) && Objects.equals(this.notificationContact, productOrderCreate.notificationContact) && Objects.equals(this.priority, productOrderCreate.priority) && Objects.equals(this.requestedCompletionDate, productOrderCreate.requestedCompletionDate) && Objects.equals(this.requestedStartDate, productOrderCreate.requestedStartDate) && Objects.equals(this.agreement, productOrderCreate.agreement) && Objects.equals(this.billingAccount, productOrderCreate.billingAccount) && Objects.equals(this.channel, productOrderCreate.channel) && Objects.equals(this.note, productOrderCreate.note) && Objects.equals(this.orderTotalPrice, productOrderCreate.orderTotalPrice) && Objects.equals(this.payment, productOrderCreate.payment) && Objects.equals(this.productOfferingQualification, productOrderCreate.productOfferingQualification) && Objects.equals(this.productOrderItem, productOrderCreate.productOrderItem) && Objects.equals(this.quote, productOrderCreate.quote) && Objects.equals(this.relatedParty, productOrderCreate.relatedParty) && Objects.equals(this.baseType, productOrderCreate.baseType) && Objects.equals(this.schemaLocation, productOrderCreate.schemaLocation) && Objects.equals(this.type, productOrderCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.cancellationDate, this.cancellationReason, this.category, this.description, this.externalId, this.notificationContact, this.priority, this.requestedCompletionDate, this.requestedStartDate, this.agreement, this.billingAccount, this.channel, this.note, this.orderTotalPrice, this.payment, this.productOfferingQualification, this.productOrderItem, this.quote, this.relatedParty, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOrderCreate {\n");
        sb.append("    cancellationDate: ").append(this.toIndentedString(this.cancellationDate)).append("\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString(this.cancellationReason)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    notificationContact: ").append(this.toIndentedString(this.notificationContact)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    billingAccount: ").append(this.toIndentedString(this.billingAccount)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderTotalPrice: ").append(this.toIndentedString(this.orderTotalPrice)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    productOfferingQualification: ").append(this.toIndentedString(this.productOfferingQualification)).append("\n");
        sb.append("    productOrderItem: ").append(this.toIndentedString(this.productOrderItem)).append("\n");
        sb.append("    quote: ").append(this.toIndentedString(this.quote)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

