/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.UserPartRoleType;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.pim637.model.BillingAccountRef;
import org.etsi.osl.tmf.po622.model.AgreementRef;
import org.etsi.osl.tmf.po622.model.OrderPrice;
import org.etsi.osl.tmf.po622.model.PaymentRef;
import org.etsi.osl.tmf.po622.model.ProductOfferingQualificationRef;
import org.etsi.osl.tmf.po622.model.ProductOrderItem;
import org.etsi.osl.tmf.po622.model.ProductOrderStateType;
import org.etsi.osl.tmf.po622.model.QuoteRef;
import org.etsi.osl.tmf.po622.model.RelatedChannel;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Product Order is a type of order which  can  be used to place an order between a customer and a service provider or between a service provider and a partner and vice versa,")
@Validated
@Entity(name="ProductOrder")
@JsonIgnoreProperties(value={"orderRequester"})
public class ProductOrder
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="cancellationDate")
    private OffsetDateTime cancellationDate = null;
    @JsonProperty(value="cancellationReason")
    private String cancellationReason = null;
    @JsonProperty(value="category")
    private String category = null;
    private OffsetDateTime completionDate = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    private OffsetDateTime expectedCompletionDate = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="notificationContact")
    private String notificationContact = null;
    private OffsetDateTime orderDate = null;
    @JsonProperty(value="priority")
    private String priority = null;
    private OffsetDateTime requestedCompletionDate = null;
    private OffsetDateTime requestedStartDate = null;
    @JsonProperty(value="agreement")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AgreementRef> agreement = new HashSet<AgreementRef>();
    @JsonProperty(value="billingAccount")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="billing_acc_refuuid", referencedColumnName="uuid")
    private BillingAccountRef billingAccount = null;
    @JsonProperty(value="channel")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedChannel> channel = new HashSet<RelatedChannel>();
    @JsonProperty(value="note")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Note> note = new HashSet<Note>();
    @JsonProperty(value="orderTotalPrice")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OrderPrice> orderTotalPrice = new HashSet<OrderPrice>();
    @JsonProperty(value="payment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PaymentRef> payment = new HashSet<PaymentRef>();
    @JsonProperty(value="productOfferingQualification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductOfferingQualificationRef> productOfferingQualification = new HashSet<ProductOfferingQualificationRef>();
    @JsonProperty(value="productOrderItem")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductOrderItem> productOrderItem = new HashSet<ProductOrderItem>();
    @JsonProperty(value="quote")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<QuoteRef> quote = new HashSet<QuoteRef>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="state")
    private ProductOrderStateType state = ProductOrderStateType.INITIAL;

    @Schema(description="ID created on repository side (OM system)")
    public String getId() {
        if (this.id != null && this.uuid == null) {
            return this.id;
        }
        return this.uuid;
    }

    public ProductOrder href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink to access the order")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public ProductOrder cancellationDate(OffsetDateTime cancellationDate) {
        this.cancellationDate = cancellationDate;
        return this;
    }

    @Schema(description="Date when the order is cancelled. This is used when order is cancelled. ")
    @Valid
    public OffsetDateTime getCancellationDate() {
        return this.cancellationDate;
    }

    public void setCancellationDate(OffsetDateTime cancellationDate) {
        this.cancellationDate = cancellationDate;
    }

    public ProductOrder cancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Schema(description="Reason why the order is cancelled. This is used when order is cancelled. ")
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public ProductOrder category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Used to categorize the order from a business perspective that can be useful for the OM system (e.g. \"enterprise\", \"residential\", ...)")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ProductOrder completionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Schema(description="Date when the order was completed")
    @Valid
    @JsonProperty(value="completionDate")
    public String getCompletionDateString() {
        if (this.completionDate == null) {
            return null;
        }
        return this.completionDate.toString();
    }

    @Valid
    public OffsetDateTime getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setCompletionDate(String completionDate) {
        if (completionDate != null) {
            this.completionDate = OffsetDateTime.parse(completionDate);
        }
    }

    public ProductOrder description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the product order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductOrder expectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
        return this;
    }

    @Schema(description="Expected delivery date amended by the provider")
    @JsonProperty(value="expectedCompletionDate")
    public String getExpectedCompletionDateString() {
        if (this.expectedCompletionDate == null) {
            return null;
        }
        return this.expectedCompletionDate.toString();
    }

    @Valid
    public OffsetDateTime getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public void setExpectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public void setExpectedCompletionDate(String expectedCompletionDate) {
        if (expectedCompletionDate != null) {
            this.expectedCompletionDate = OffsetDateTime.parse(expectedCompletionDate);
        }
    }

    public ProductOrder externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="ID given by the consumer and only understandable by him (to facilitate his searches afterwards)")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ProductOrder notificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
        return this;
    }

    @Schema(description="Contact attached to the order to send back information regarding this order")
    public String getNotificationContact() {
        return this.notificationContact;
    }

    public void setNotificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
    }

    public ProductOrder orderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Schema(description="Date when the order was created")
    @Valid
    @JsonProperty(value="orderDate")
    public String getOrderDateString() {
        if (this.orderDate == null) {
            return null;
        }
        return this.orderDate.toString();
    }

    @Valid
    public OffsetDateTime getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
    }

    public void setOrderDate(String orderDate) {
        if (orderDate != null) {
            this.orderDate = OffsetDateTime.parse(orderDate);
        }
    }

    public ProductOrder priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A way that can be used by consumers to prioritize orders in OM system (from 0 to 4 : 0 is the highest priority, and 4 the lowest)")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public ProductOrder requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    @Schema(description="Requested delivery date from the requestor perspective")
    @Valid
    @JsonProperty(value="requestedCompletionDate")
    public String getRequestedCompletionDateString() {
        if (this.requestedCompletionDate == null) {
            return null;
        }
        return this.requestedCompletionDate.toString();
    }

    @Valid
    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public void setRequestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
    }

    public ProductOrder requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    @Schema(description="Order fulfillment start date wished by the requestor. This is used when, for any reason, requestor cannot allow seller to begin to operationally begin the fulfillment before a date. ")
    @Valid
    @JsonProperty(value="requestedStartDate")
    public String getRequestedStartDateString() {
        if (this.requestedStartDate == null) {
            return null;
        }
        return this.requestedStartDate.toString();
    }

    @Valid
    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    public void setRequestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ProductOrder agreement(Set<AgreementRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public ProductOrder addAgreementItem(AgreementRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new HashSet<AgreementRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="A reference to an agreement defined in the context of the product order")
    @Valid
    public Set<AgreementRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Set<AgreementRef> agreement) {
        this.agreement = agreement;
    }

    public ProductOrder billingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
        return this;
    }

    @Schema(description="")
    @Valid
    public BillingAccountRef getBillingAccount() {
        return this.billingAccount;
    }

    public void setBillingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
    }

    public ProductOrder channel(Set<RelatedChannel> channel) {
        this.channel = channel;
        return this;
    }

    public ProductOrder addChannelItem(RelatedChannel channelItem) {
        if (this.channel == null) {
            this.channel = new HashSet<RelatedChannel>();
        }
        this.channel.add(channelItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedChannel> getChannel() {
        return this.channel;
    }

    public void setChannel(Set<RelatedChannel> channel) {
        this.channel = channel;
    }

    public ProductOrder note(Set<Note> note) {
        this.note = note;
        return this;
    }

    public ProductOrder addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new HashSet<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Note> getNote() {
        return this.note;
    }

    public void setNote(Set<Note> note) {
        this.note = note;
    }

    public ProductOrder orderTotalPrice(Set<OrderPrice> orderTotalPrice) {
        this.orderTotalPrice = orderTotalPrice;
        return this;
    }

    public ProductOrder addOrderTotalPriceItem(OrderPrice orderTotalPriceItem) {
        if (this.orderTotalPrice == null) {
            this.orderTotalPrice = new HashSet<OrderPrice>();
        }
        this.orderTotalPrice.add(orderTotalPriceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OrderPrice> getOrderTotalPrice() {
        return this.orderTotalPrice;
    }

    public void setOrderTotalPrice(Set<OrderPrice> orderTotalPrice) {
        this.orderTotalPrice = orderTotalPrice;
    }

    public ProductOrder payment(Set<PaymentRef> payment) {
        this.payment = payment;
        return this;
    }

    public ProductOrder addPaymentItem(PaymentRef paymentItem) {
        if (this.payment == null) {
            this.payment = new HashSet<PaymentRef>();
        }
        this.payment.add(paymentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<PaymentRef> getPayment() {
        return this.payment;
    }

    public void setPayment(Set<PaymentRef> payment) {
        this.payment = payment;
    }

    public ProductOrder productOfferingQualification(Set<ProductOfferingQualificationRef> productOfferingQualification) {
        this.productOfferingQualification = productOfferingQualification;
        return this;
    }

    public ProductOrder addProductOfferingQualificationItem(ProductOfferingQualificationRef productOfferingQualificationItem) {
        if (this.productOfferingQualification == null) {
            this.productOfferingQualification = new HashSet<ProductOfferingQualificationRef>();
        }
        this.productOfferingQualification.add(productOfferingQualificationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ProductOfferingQualificationRef> getProductOfferingQualification() {
        return this.productOfferingQualification;
    }

    public void setProductOfferingQualification(Set<ProductOfferingQualificationRef> productOfferingQualification) {
        this.productOfferingQualification = productOfferingQualification;
    }

    public ProductOrder productOrderItem(Set<ProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
        return this;
    }

    public ProductOrder addProductOrderItemItem(ProductOrderItem productOrderItemItem) {
        this.productOrderItem.add(productOrderItemItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) Set<ProductOrderItem> getProductOrderItem() {
        return this.productOrderItem;
    }

    public void setProductOrderItem(Set<ProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
    }

    public ProductOrder quote(Set<QuoteRef> quote) {
        this.quote = quote;
        return this;
    }

    public ProductOrder addQuoteItem(QuoteRef quoteItem) {
        if (this.quote == null) {
            this.quote = new HashSet<QuoteRef>();
        }
        this.quote.add(quoteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<QuoteRef> getQuote() {
        return this.quote;
    }

    public void setQuote(Set<QuoteRef> quote) {
        this.quote = quote;
    }

    public ProductOrder relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ProductOrder addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ProductOrder state(ProductOrderStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="")
    @Valid
    public ProductOrderStateType getState() {
        return this.state;
    }

    public void setState(ProductOrderStateType state) {
        this.state = state;
    }

    @Override
    public ProductOrder baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public ProductOrder schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ProductOrder type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOrder productOrder = (ProductOrder)o;
        return Objects.equals(this.id, productOrder.id) && Objects.equals(this.href, productOrder.href) && Objects.equals(this.cancellationDate, productOrder.cancellationDate) && Objects.equals(this.cancellationReason, productOrder.cancellationReason) && Objects.equals(this.category, productOrder.category) && Objects.equals(this.completionDate, productOrder.completionDate) && Objects.equals(this.description, productOrder.description) && Objects.equals(this.expectedCompletionDate, productOrder.expectedCompletionDate) && Objects.equals(this.externalId, productOrder.externalId) && Objects.equals(this.notificationContact, productOrder.notificationContact) && Objects.equals(this.orderDate, productOrder.orderDate) && Objects.equals(this.priority, productOrder.priority) && Objects.equals(this.requestedCompletionDate, productOrder.requestedCompletionDate) && Objects.equals(this.requestedStartDate, productOrder.requestedStartDate) && Objects.equals(this.agreement, productOrder.agreement) && Objects.equals(this.billingAccount, productOrder.billingAccount) && Objects.equals(this.channel, productOrder.channel) && Objects.equals(this.note, productOrder.note) && Objects.equals(this.orderTotalPrice, productOrder.orderTotalPrice) && Objects.equals(this.payment, productOrder.payment) && Objects.equals(this.productOfferingQualification, productOrder.productOfferingQualification) && Objects.equals(this.productOrderItem, productOrder.productOrderItem) && Objects.equals(this.quote, productOrder.quote) && Objects.equals(this.relatedParty, productOrder.relatedParty) && Objects.equals((Object)this.state, (Object)productOrder.state) && Objects.equals(this.baseType, productOrder.baseType) && Objects.equals(this.schemaLocation, productOrder.schemaLocation) && Objects.equals(this.type, productOrder.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.href, this.cancellationDate, this.cancellationReason, this.category, this.completionDate, this.description, this.expectedCompletionDate, this.externalId, this.notificationContact, this.orderDate, this.priority, this.requestedCompletionDate, this.requestedStartDate, this.agreement, this.billingAccount, this.channel, this.note, this.orderTotalPrice, this.payment, this.productOfferingQualification, this.productOrderItem, this.quote, this.relatedParty, this.state, this.baseType, this.schemaLocation, this.type});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOrder {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    cancellationDate: ").append(this.toIndentedString(this.cancellationDate)).append("\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString(this.cancellationReason)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expectedCompletionDate: ").append(this.toIndentedString(this.expectedCompletionDate)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    notificationContact: ").append(this.toIndentedString(this.notificationContact)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    billingAccount: ").append(this.toIndentedString(this.billingAccount)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderTotalPrice: ").append(this.toIndentedString(this.orderTotalPrice)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    productOfferingQualification: ").append(this.toIndentedString(this.productOfferingQualification)).append("\n");
        sb.append("    productOrderItem: ").append(this.toIndentedString(this.productOrderItem)).append("\n");
        sb.append("    quote: ").append(this.toIndentedString(this.quote)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public ProductOrderItem findOrderItemById(String id) {
        for (ProductOrderItem oi : this.productOrderItem) {
            if (!oi.getId().equals(id)) continue;
            return oi;
        }
        return null;
    }

    public RelatedParty getOrderRequester() {
        for (RelatedParty rp : this.relatedParty) {
            if (!rp.getRole().equals(UserPartRoleType.REQUESTER.toString())) continue;
            return rp;
        }
        return null;
    }
}

