/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.Quantity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Description of a productTerm linked to this orderItem. This represent a commitment with a duration")
@Validated
@Entity(name="OrderTerm622")
public class OrderTerm
extends BaseRootNamedEntity {
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="duration")
    private Quantity duration = null;

    public OrderTerm description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the productOrderTerm")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public OrderTerm name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the productOrderTerm")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public OrderTerm duration(Quantity duration) {
        this.duration = duration;
        return this;
    }

    @Schema(description="")
    @Valid
    public Quantity getDuration() {
        return this.duration;
    }

    public void setDuration(Quantity duration) {
        this.duration = duration;
    }

    @Override
    public OrderTerm baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public OrderTerm schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public OrderTerm type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderTerm orderTerm = (OrderTerm)o;
        return Objects.equals(this.description, orderTerm.description) && Objects.equals(this.name, orderTerm.name) && Objects.equals(this.duration, orderTerm.duration) && Objects.equals(this.baseType, orderTerm.baseType) && Objects.equals(this.schemaLocation, orderTerm.schemaLocation) && Objects.equals(this.type, orderTerm.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.name, this.duration, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderTerm {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

