/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceRef;
import org.etsi.osl.tmf.pim637.model.BillingAccountRef;
import org.etsi.osl.tmf.pim637.model.Price;
import org.etsi.osl.tmf.pim637.model.PriceAlteration;
import org.springframework.validation.annotation.Validated;

@Schema(description="An amount, usually of money, that represents the actual price paid by the Customer for this item or this order")
@Validated
@Entity(name="OrderPrice622")
public class OrderPrice
extends BaseRootNamedEntity {
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="priceType")
    private String priceType = null;
    @JsonProperty(value="recurringChargePeriod")
    private String recurringChargePeriod = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="billingAccount")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="billing_acc_refuuid", referencedColumnName="uuid")
    private BillingAccountRef billingAccount = null;
    @JsonProperty(value="price")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="price_uuid", referencedColumnName="uuid")
    private Price price = null;
    @JsonProperty(value="priceAlteration")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PriceAlteration> priceAlteration = new HashSet<PriceAlteration>();
    @JsonProperty(value="productOfferingPrice")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="productOffPr_refuuid", referencedColumnName="uuid")
    private ProductOfferingPriceRef productOfferingPrice = null;

    public OrderPrice description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail the semantics of this order item price.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public OrderPrice name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="A short descriptive name such as \"Subscription price\".")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public OrderPrice priceType(String priceType) {
        this.priceType = priceType;
        return this;
    }

    @Schema(description="A category that describes the price, such as recurring, discount, allowance, penalty, and so forth")
    public String getPriceType() {
        return this.priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public OrderPrice recurringChargePeriod(String recurringChargePeriod) {
        this.recurringChargePeriod = recurringChargePeriod;
        return this;
    }

    @Schema(description="Could be month, week...")
    public String getRecurringChargePeriod() {
        return this.recurringChargePeriod;
    }

    public void setRecurringChargePeriod(String recurringChargePeriod) {
        this.recurringChargePeriod = recurringChargePeriod;
    }

    public OrderPrice unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="Could be minutes, GB...")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public OrderPrice billingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
        return this;
    }

    @Schema(description="")
    @Valid
    public BillingAccountRef getBillingAccount() {
        return this.billingAccount;
    }

    public void setBillingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
    }

    public OrderPrice price(Price price) {
        this.price = price;
        return this;
    }

    @Schema(description="")
    @Valid
    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price price) {
        this.price = price;
    }

    public OrderPrice priceAlteration(Set<PriceAlteration> priceAlteration) {
        this.priceAlteration = priceAlteration;
        return this;
    }

    public OrderPrice addPriceAlterationItem(PriceAlteration priceAlterationItem) {
        if (this.priceAlteration == null) {
            this.priceAlteration = new HashSet<PriceAlteration>();
        }
        this.priceAlteration.add(priceAlterationItem);
        return this;
    }

    @Schema(description="a strucuture used to describe a price alteration")
    @Valid
    public Set<PriceAlteration> getPriceAlteration() {
        return this.priceAlteration;
    }

    public void setPriceAlteration(Set<PriceAlteration> priceAlteration) {
        this.priceAlteration = priceAlteration;
    }

    public OrderPrice productOfferingPrice(ProductOfferingPriceRef productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
        return this;
    }

    @Schema(description="")
    @Valid
    public ProductOfferingPriceRef getProductOfferingPrice() {
        return this.productOfferingPrice;
    }

    public void setProductOfferingPrice(ProductOfferingPriceRef productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
    }

    @Override
    public OrderPrice baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public OrderPrice schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public OrderPrice type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPrice orderPrice = (OrderPrice)o;
        return Objects.equals(this.description, orderPrice.description) && Objects.equals(this.name, orderPrice.name) && Objects.equals(this.priceType, orderPrice.priceType) && Objects.equals(this.recurringChargePeriod, orderPrice.recurringChargePeriod) && Objects.equals(this.unitOfMeasure, orderPrice.unitOfMeasure) && Objects.equals(this.billingAccount, orderPrice.billingAccount) && Objects.equals(this.price, orderPrice.price) && Objects.equals(this.priceAlteration, orderPrice.priceAlteration) && Objects.equals(this.productOfferingPrice, orderPrice.productOfferingPrice) && Objects.equals(this.baseType, orderPrice.baseType) && Objects.equals(this.schemaLocation, orderPrice.schemaLocation) && Objects.equals(this.type, orderPrice.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.name, this.priceType, this.recurringChargePeriod, this.unitOfMeasure, this.billingAccount, this.price, this.priceAlteration, this.productOfferingPrice, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderPrice {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priceType: ").append(this.toIndentedString(this.priceType)).append("\n");
        sb.append("    recurringChargePeriod: ").append(this.toIndentedString(this.recurringChargePeriod)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    billingAccount: ").append(this.toIndentedString(this.billingAccount)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    priceAlteration: ").append(this.toIndentedString(this.priceAlteration)).append("\n");
        sb.append("    productOfferingPrice: ").append(this.toIndentedString(this.productOfferingPrice)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

