/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.po622.model.ProductOrderRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Request for cancellation an existing product order Skipped properties: id,href,state,effectiveCancellationDate")
@Validated
public class CancelProductOrderCreate {
    @JsonProperty(value="cancellationReason")
    private String cancellationReason = null;
    @JsonProperty(value="requestedCancellationDate")
    private OffsetDateTime requestedCancellationDate = null;
    @JsonProperty(value="productOrder")
    private ProductOrderRef productOrder = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public CancelProductOrderCreate cancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Schema(description="Reason why the order is cancelled.")
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public CancelProductOrderCreate requestedCancellationDate(OffsetDateTime requestedCancellationDate) {
        this.requestedCancellationDate = requestedCancellationDate;
        return this;
    }

    @Schema(description="Date when the submitter wants the order to be cancelled")
    @Valid
    public OffsetDateTime getRequestedCancellationDate() {
        return this.requestedCancellationDate;
    }

    public void setRequestedCancellationDate(OffsetDateTime requestedCancellationDate) {
        this.requestedCancellationDate = requestedCancellationDate;
    }

    public CancelProductOrderCreate productOrder(ProductOrderRef productOrder) {
        this.productOrder = productOrder;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductOrderRef getProductOrder() {
        return this.productOrder;
    }

    public void setProductOrder(ProductOrderRef productOrder) {
        this.productOrder = productOrder;
    }

    public CancelProductOrderCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CancelProductOrderCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CancelProductOrderCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelProductOrderCreate cancelProductOrderCreate = (CancelProductOrderCreate)o;
        return Objects.equals(this.cancellationReason, cancelProductOrderCreate.cancellationReason) && Objects.equals(this.requestedCancellationDate, cancelProductOrderCreate.requestedCancellationDate) && Objects.equals(this.productOrder, cancelProductOrderCreate.productOrder) && Objects.equals(this.baseType, cancelProductOrderCreate.baseType) && Objects.equals(this.schemaLocation, cancelProductOrderCreate.schemaLocation) && Objects.equals(this.type, cancelProductOrderCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.cancellationReason, this.requestedCancellationDate, this.productOrder, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelProductOrderCreate {\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString(this.cancellationReason)).append("\n");
        sb.append("    requestedCancellationDate: ").append(this.toIndentedString(this.requestedCancellationDate)).append("\n");
        sb.append("    productOrder: ").append(this.toIndentedString(this.productOrder)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

