/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.po622.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.po622.model.ProductOrderRef;
import org.etsi.osl.tmf.po622.model.TaskStateType;
import org.springframework.validation.annotation.Validated;

@Schema(description="Request for cancellation an existing product order")
@Validated
public class CancelProductOrder {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="cancellationReason")
    private String cancellationReason = null;
    @JsonProperty(value="effectiveCancellationDate")
    private OffsetDateTime effectiveCancellationDate = null;
    @JsonProperty(value="requestedCancellationDate")
    private OffsetDateTime requestedCancellationDate = null;
    @JsonProperty(value="productOrder")
    private ProductOrderRef productOrder = null;
    @JsonProperty(value="state")
    private TaskStateType state = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public CancelProductOrder id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="id of the cancellation request (this is not an order id)")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CancelProductOrder href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Hyperlink to access the cancellation request")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public CancelProductOrder cancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Schema(description="Reason why the order is cancelled.")
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public CancelProductOrder effectiveCancellationDate(OffsetDateTime effectiveCancellationDate) {
        this.effectiveCancellationDate = effectiveCancellationDate;
        return this;
    }

    @Schema(description="Date when the order is cancelled.")
    @Valid
    public OffsetDateTime getEffectiveCancellationDate() {
        return this.effectiveCancellationDate;
    }

    public void setEffectiveCancellationDate(OffsetDateTime effectiveCancellationDate) {
        this.effectiveCancellationDate = effectiveCancellationDate;
    }

    public CancelProductOrder requestedCancellationDate(OffsetDateTime requestedCancellationDate) {
        this.requestedCancellationDate = requestedCancellationDate;
        return this;
    }

    @Schema(description="Date when the submitter wants the order to be cancelled")
    @Valid
    public OffsetDateTime getRequestedCancellationDate() {
        return this.requestedCancellationDate;
    }

    public void setRequestedCancellationDate(OffsetDateTime requestedCancellationDate) {
        this.requestedCancellationDate = requestedCancellationDate;
    }

    public CancelProductOrder productOrder(ProductOrderRef productOrder) {
        this.productOrder = productOrder;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductOrderRef getProductOrder() {
        return this.productOrder;
    }

    public void setProductOrder(ProductOrderRef productOrder) {
        this.productOrder = productOrder;
    }

    public CancelProductOrder state(TaskStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="")
    @Valid
    public TaskStateType getState() {
        return this.state;
    }

    public void setState(TaskStateType state) {
        this.state = state;
    }

    public CancelProductOrder baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CancelProductOrder schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CancelProductOrder type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelProductOrder cancelProductOrder = (CancelProductOrder)o;
        return Objects.equals(this.id, cancelProductOrder.id) && Objects.equals(this.href, cancelProductOrder.href) && Objects.equals(this.cancellationReason, cancelProductOrder.cancellationReason) && Objects.equals(this.effectiveCancellationDate, cancelProductOrder.effectiveCancellationDate) && Objects.equals(this.requestedCancellationDate, cancelProductOrder.requestedCancellationDate) && Objects.equals(this.productOrder, cancelProductOrder.productOrder) && Objects.equals((Object)this.state, (Object)cancelProductOrder.state) && Objects.equals(this.baseType, cancelProductOrder.baseType) && Objects.equals(this.schemaLocation, cancelProductOrder.schemaLocation) && Objects.equals(this.type, cancelProductOrder.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.href, this.cancellationReason, this.effectiveCancellationDate, this.requestedCancellationDate, this.productOrder, this.state, this.baseType, this.schemaLocation, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelProductOrder {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString(this.cancellationReason)).append("\n");
        sb.append("    effectiveCancellationDate: ").append(this.toIndentedString(this.effectiveCancellationDate)).append("\n");
        sb.append("    requestedCancellationDate: ").append(this.toIndentedString(this.requestedCancellationDate)).append("\n");
        sb.append("    productOrder: ").append(this.toIndentedString(this.productOrder)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

