/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm632.model.TaxDefinition;
import org.springframework.validation.annotation.Validated;

@Schema(description="A tax exemption certificate represents a tax exemption granted to a party (individual or organization) by a tax jurisdiction which may be a city, state, country,... An exemption has a certificate identifier (received from the jurisdiction that levied the tax) and a validity period. An exemption is per tax types and determines for each type of tax what portion of the tax is exempted (partial by percentage or complete) via the tax definition.")
@Validated
@Entity
public class TaxExemptionCertificate
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="attachment")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="attachment_refid", referencedColumnName="uuid")
    private AttachmentRefOrValue attachment = null;
    @JsonProperty(value="taxDefinition")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<TaxDefinition> taxDefinition = new HashSet<TaxDefinition>();
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public TaxExemptionCertificate id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the certificate of the tax exemption")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TaxExemptionCertificate attachment(AttachmentRefOrValue attachment) {
        this.attachment = attachment;
        return this;
    }

    @Schema(description="")
    @Valid
    public AttachmentRefOrValue getAttachment() {
        return this.attachment;
    }

    public void setAttachment(AttachmentRefOrValue attachment) {
        this.attachment = attachment;
    }

    public TaxExemptionCertificate taxDefinition(Set<TaxDefinition> taxDefinition) {
        this.taxDefinition = taxDefinition;
        return this;
    }

    public TaxExemptionCertificate addTaxDefinitionItem(TaxDefinition taxDefinitionItem) {
        if (this.taxDefinition == null) {
            this.taxDefinition = new HashSet<TaxDefinition>();
        }
        this.taxDefinition.add(taxDefinitionItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<TaxDefinition> getTaxDefinition() {
        return this.taxDefinition;
    }

    public void setTaxDefinition(Set<TaxDefinition> taxDefinition) {
        this.taxDefinition = taxDefinition;
    }

    public TaxExemptionCertificate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public TaxExemptionCertificate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public TaxExemptionCertificate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public TaxExemptionCertificate type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxExemptionCertificate taxExemptionCertificate = (TaxExemptionCertificate)o;
        return Objects.equals(this.id, taxExemptionCertificate.id) && Objects.equals(this.attachment, taxExemptionCertificate.attachment) && Objects.equals(this.taxDefinition, taxExemptionCertificate.taxDefinition) && Objects.equals(this.validFor, taxExemptionCertificate.validFor) && Objects.equals(this.baseType, taxExemptionCertificate.baseType) && Objects.equals(this.schemaLocation, taxExemptionCertificate.schemaLocation) && Objects.equals(this.type, taxExemptionCertificate.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.attachment, this.taxDefinition, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxExemptionCertificate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    taxDefinition: ").append(this.toIndentedString(this.taxDefinition)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

