/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Reference of a tax definition. A tax is levied by an authorized tax jurisdiction. There are many different types of tax (Federal Tax levied by the US Government, State Tax levied by the State of California,\u2026).")
@Validated
@Entity
public class TaxDefinition
extends BaseRootNamedEntity {
    @JsonProperty(value="taxType")
    private String taxType = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    @Schema(description="Unique identifier of the tax.")
    @JsonProperty(value="id")
    public String getId() {
        return this.uuid;
    }

    public TaxDefinition taxType(String taxType) {
        this.taxType = taxType;
        return this;
    }

    @Schema(description="Type of  the tax.")
    public String getTaxType() {
        return this.taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public TaxDefinition referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxDefinition taxDefinition = (TaxDefinition)o;
        return Objects.equals(this.uuid, taxDefinition.uuid) && Objects.equals(this.name, taxDefinition.name) && Objects.equals(this.taxType, taxDefinition.taxType) && Objects.equals(this.baseType, taxDefinition.baseType) && Objects.equals(this.schemaLocation, taxDefinition.schemaLocation) && Objects.equals(this.type, taxDefinition.type) && Objects.equals(this.referredType, taxDefinition.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    taxType: ").append(this.toIndentedString(this.taxType)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

