/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Skills evaluated for an individual with a level and possibly with a limited validity when an obsolescence is defined (Ex: the first-aid certificate first level is limited to one year and an update training is required each year to keep the level).")
@Validated
@Entity
public class Skill
extends BaseRootEntity {
    @JsonProperty(value="comment")
    private String comment = null;
    @JsonProperty(value="evaluatedLevel")
    private String evaluatedLevel = null;
    @JsonProperty(value="skillCode")
    private String skillCode = null;
    @JsonProperty(value="skillName")
    private String skillName = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public Skill comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Schema(description="A free text comment linked to the evaluation done")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Skill evaluatedLevel(String evaluatedLevel) {
        this.evaluatedLevel = evaluatedLevel;
        return this;
    }

    @Schema(description="Level of expertise in a skill evaluated for an individual")
    public String getEvaluatedLevel() {
        return this.evaluatedLevel;
    }

    public void setEvaluatedLevel(String evaluatedLevel) {
        this.evaluatedLevel = evaluatedLevel;
    }

    public Skill skillCode(String skillCode) {
        this.skillCode = skillCode;
        return this;
    }

    @Schema(description="Code of the skill")
    public String getSkillCode() {
        return this.skillCode;
    }

    public void setSkillCode(String skillCode) {
        this.skillCode = skillCode;
    }

    public Skill skillName(String skillName) {
        this.skillName = skillName;
        return this;
    }

    @Schema(description="Name of the skill such as Java language,\u2026")
    public String getSkillName() {
        return this.skillName;
    }

    public void setSkillName(String skillName) {
        this.skillName = skillName;
    }

    public Skill validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Skill skill = (Skill)o;
        return Objects.equals(this.comment, skill.comment) && Objects.equals(this.evaluatedLevel, skill.evaluatedLevel) && Objects.equals(this.skillCode, skill.skillCode) && Objects.equals(this.skillName, skill.skillName) && Objects.equals(this.validFor, skill.validFor) && Objects.equals(this.baseType, skill.baseType) && Objects.equals(this.schemaLocation, skill.schemaLocation) && Objects.equals(this.type, skill.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Skill {\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    evaluatedLevel: ").append(this.toIndentedString(this.evaluatedLevel)).append("\n");
        sb.append("    skillCode: ").append(this.toIndentedString(this.skillCode)).append("\n");
        sb.append("    skillName: ").append(this.toIndentedString(this.skillName)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

