/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="An individual might be evaluated for its worthiness and this evaluation might be based on a credit rating given by a credit agency.")
@Validated
@Entity
public class PartyCreditProfile
extends BaseRootEntity {
    @JsonProperty(value="creditAgencyName")
    private String creditAgencyName = null;
    @JsonProperty(value="creditAgencyType")
    private String creditAgencyType = null;
    @JsonProperty(value="ratingReference")
    private String ratingReference = null;
    @JsonProperty(value="ratingScore")
    private Integer ratingScore = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public PartyCreditProfile creditAgencyName(String creditAgencyName) {
        this.creditAgencyName = creditAgencyName;
        return this;
    }

    @Schema(description="Name of the credit agency giving the score")
    public String getCreditAgencyName() {
        return this.creditAgencyName;
    }

    public void setCreditAgencyName(String creditAgencyName) {
        this.creditAgencyName = creditAgencyName;
    }

    public PartyCreditProfile creditAgencyType(String creditAgencyType) {
        this.creditAgencyType = creditAgencyType;
        return this;
    }

    @Schema(description="Type of the credit agency giving the score")
    public String getCreditAgencyType() {
        return this.creditAgencyType;
    }

    public void setCreditAgencyType(String creditAgencyType) {
        this.creditAgencyType = creditAgencyType;
    }

    public PartyCreditProfile ratingReference(String ratingReference) {
        this.ratingReference = ratingReference;
        return this;
    }

    @Schema(description="Reference corresponding to the credit rating")
    public String getRatingReference() {
        return this.ratingReference;
    }

    public void setRatingReference(String ratingReference) {
        this.ratingReference = ratingReference;
    }

    public PartyCreditProfile ratingScore(Integer ratingScore) {
        this.ratingScore = ratingScore;
        return this;
    }

    @Schema(description="A measure of a party\u2019s creditworthiness calculated on the basis of a combination of factors such as their income and credit history")
    public Integer getRatingScore() {
        return this.ratingScore;
    }

    public void setRatingScore(Integer ratingScore) {
        this.ratingScore = ratingScore;
    }

    public PartyCreditProfile validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartyCreditProfile partyCreditProfile = (PartyCreditProfile)o;
        return Objects.equals(this.creditAgencyName, partyCreditProfile.creditAgencyName) && Objects.equals(this.creditAgencyType, partyCreditProfile.creditAgencyType) && Objects.equals(this.ratingReference, partyCreditProfile.ratingReference) && Objects.equals(this.ratingScore, partyCreditProfile.ratingScore) && Objects.equals(this.validFor, partyCreditProfile.validFor) && Objects.equals(this.baseType, partyCreditProfile.baseType) && Objects.equals(this.schemaLocation, partyCreditProfile.schemaLocation) && Objects.equals(this.type, partyCreditProfile.type);
    }

    public int hashCode() {
        return Objects.hash(this.creditAgencyName, this.creditAgencyType, this.ratingReference, this.ratingScore, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartyCreditProfile {\n");
        sb.append("    creditAgencyName: ").append(this.toIndentedString(this.creditAgencyName)).append("\n");
        sb.append("    creditAgencyType: ").append(this.toIndentedString(this.creditAgencyType)).append("\n");
        sb.append("    ratingReference: ").append(this.toIndentedString(this.ratingReference)).append("\n");
        sb.append("    ratingScore: ").append(this.toIndentedString(this.ratingScore)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

