/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.ContactMedium;
import org.etsi.osl.tmf.pm632.model.ExternalReference;
import org.etsi.osl.tmf.pm632.model.PartyCreditProfile;
import org.etsi.osl.tmf.pm632.model.TaxExemptionCertificate;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="Generic Party structure used to define commonalities between sub concepts of Individual and Organization.")
@Validated
@Entity
public class Party
extends BaseRootEntity {
    @JsonProperty(value="contactMedium")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ContactMedium> contactMedium = new HashSet<ContactMedium>();
    @JsonProperty(value="creditRating")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PartyCreditProfile> creditRating = new HashSet<PartyCreditProfile>();
    @JsonProperty(value="externalReference")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ExternalReference> externalReference = new HashSet<ExternalReference>();
    @JsonProperty(value="partyCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Characteristic> partyCharacteristic = new HashSet<Characteristic>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="taxExemptionCertificate")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<TaxExemptionCertificate> taxExemptionCertificate = new HashSet<TaxExemptionCertificate>();

    @Schema(description="Unique identifier of the organization")
    @JsonProperty(value="id")
    public String getId() {
        return this.uuid;
    }

    public Party contactMedium(Set<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
        return this;
    }

    public Party addContactMediumItem(ContactMedium contactMediumItem) {
        if (this.contactMedium == null) {
            this.contactMedium = new HashSet<ContactMedium>();
        }
        this.contactMedium.add(contactMediumItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ContactMedium> getContactMedium() {
        return this.contactMedium;
    }

    public void setContactMedium(Set<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
    }

    public Party creditRating(Set<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
        return this;
    }

    public Party addCreditRatingItem(PartyCreditProfile creditRatingItem) {
        if (this.creditRating == null) {
            this.creditRating = new HashSet<PartyCreditProfile>();
        }
        this.creditRating.add(creditRatingItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<PartyCreditProfile> getCreditRating() {
        return this.creditRating;
    }

    public void setCreditRating(Set<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
    }

    public Party externalReference(Set<ExternalReference> externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public Party addExternalReferenceItem(ExternalReference externalReferenceItem) {
        if (this.externalReference == null) {
            this.externalReference = new HashSet<ExternalReference>();
        }
        this.externalReference.add(externalReferenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(Set<ExternalReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Party partyCharacteristic(Set<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
        return this;
    }

    public Party addPartyCharacteristicItem(Characteristic partyCharacteristicItem) {
        if (this.partyCharacteristic == null) {
            this.partyCharacteristic = new HashSet<Characteristic>();
        }
        this.partyCharacteristic.add(partyCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Characteristic> getPartyCharacteristic() {
        return this.partyCharacteristic;
    }

    public void setPartyCharacteristic(Set<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
    }

    public Party relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Party addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Party taxExemptionCertificate(Set<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
        return this;
    }

    public Party addTaxExemptionCertificateItem(TaxExemptionCertificate taxExemptionCertificateItem) {
        if (this.taxExemptionCertificate == null) {
            this.taxExemptionCertificate = new HashSet<TaxExemptionCertificate>();
        }
        this.taxExemptionCertificate.add(taxExemptionCertificateItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<TaxExemptionCertificate> getTaxExemptionCertificate() {
        return this.taxExemptionCertificate;
    }

    public void setTaxExemptionCertificate(Set<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Party party = (Party)o;
        return Objects.equals(this.uuid, party.uuid) && Objects.equals(this.href, party.href) && Objects.equals(this.contactMedium, party.contactMedium) && Objects.equals(this.creditRating, party.creditRating) && Objects.equals(this.externalReference, party.externalReference) && Objects.equals(this.partyCharacteristic, party.partyCharacteristic) && Objects.equals(this.relatedParty, party.relatedParty) && Objects.equals(this.taxExemptionCertificate, party.taxExemptionCertificate) && Objects.equals(this.baseType, party.baseType) && Objects.equals(this.schemaLocation, party.schemaLocation) && Objects.equals(this.type, party.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Party {\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    contactMedium: ").append(this.toIndentedString(this.contactMedium)).append("\n");
        sb.append("    creditRating: ").append(this.toIndentedString(this.creditRating)).append("\n");
        sb.append("    externalReference: ").append(this.toIndentedString(this.externalReference)).append("\n");
        sb.append("    partyCharacteristic: ").append(this.toIndentedString(this.partyCharacteristic)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    taxExemptionCertificate: ").append(this.toIndentedString(this.taxExemptionCertificate)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

