/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Keeps track of other names, for example the old name of an organization.")
@Validated
@Entity
public class OtherNameOrganization
extends BaseRootNamedEntity {
    @JsonProperty(value="nameType")
    private String nameType = null;
    @JsonProperty(value="tradingName")
    private String tradingName = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    @Schema(description="Co. , Inc. , Ltd. , Pty Ltd. , Plc; , Gmbh")
    public String getNameType() {
        return this.nameType;
    }

    public void setNameType(String nameType) {
        this.nameType = nameType;
    }

    public OtherNameOrganization tradingName(String tradingName) {
        this.tradingName = tradingName;
        return this;
    }

    @Schema(description="The name that the organization trades under")
    public String getTradingName() {
        return this.tradingName;
    }

    public void setTradingName(String tradingName) {
        this.tradingName = tradingName;
    }

    public OtherNameOrganization validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtherNameOrganization otherNameOrganization = (OtherNameOrganization)o;
        return Objects.equals(this.name, otherNameOrganization.name) && Objects.equals(this.nameType, otherNameOrganization.nameType) && Objects.equals(this.tradingName, otherNameOrganization.tradingName) && Objects.equals(this.validFor, otherNameOrganization.validFor) && Objects.equals(this.baseType, otherNameOrganization.baseType) && Objects.equals(this.schemaLocation, otherNameOrganization.schemaLocation) && Objects.equals(this.type, otherNameOrganization.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.nameType, this.tradingName, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtherNameOrganization {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameType: ").append(this.toIndentedString(this.nameType)).append("\n");
        sb.append("    tradingName: ").append(this.toIndentedString(this.tradingName)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

