/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Keeps track of other names, for example the old name of a woman before marriage or an artist name.")
@Validated
@Entity
public class OtherNameIndividual
extends BaseRootEntity {
    @JsonProperty(value="aristocraticTitle")
    private String aristocraticTitle = null;
    @JsonProperty(value="familyName")
    private String familyName = null;
    @JsonProperty(value="familyNamePrefix")
    private String familyNamePrefix = null;
    @JsonProperty(value="formattedName")
    private String formattedName = null;
    @JsonProperty(value="fullName")
    private String fullName = null;
    @JsonProperty(value="generation")
    private String generation = null;
    @JsonProperty(value="givenName")
    private String givenName = null;
    @JsonProperty(value="legalName")
    private String legalName = null;
    @JsonProperty(value="middleName")
    private String middleName = null;
    @JsonProperty(value="preferredGivenName")
    private String preferredGivenName = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public OtherNameIndividual aristocraticTitle(String aristocraticTitle) {
        this.aristocraticTitle = aristocraticTitle;
        return this;
    }

    @Schema(description="e.g. Baron, Graf, Earl,\u2026")
    public String getAristocraticTitle() {
        return this.aristocraticTitle;
    }

    public void setAristocraticTitle(String aristocraticTitle) {
        this.aristocraticTitle = aristocraticTitle;
    }

    public OtherNameIndividual familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Schema(description="Contains the non-chosen or inherited name. Also known as last name in the Western context")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public OtherNameIndividual familyNamePrefix(String familyNamePrefix) {
        this.familyNamePrefix = familyNamePrefix;
        return this;
    }

    @Schema(description="Family name prefix")
    public String getFamilyNamePrefix() {
        return this.familyNamePrefix;
    }

    public void setFamilyNamePrefix(String familyNamePrefix) {
        this.familyNamePrefix = familyNamePrefix;
    }

    public OtherNameIndividual formattedName(String formattedName) {
        this.formattedName = formattedName;
        return this;
    }

    @Schema(description=". A fully formatted name in one string with all of its pieces in their proper place and all of the necessary punctuation. Useful for specific contexts (Chinese, Japanese, Korean,\u2026)")
    public String getFormattedName() {
        return this.formattedName;
    }

    public void setFormattedName(String formattedName) {
        this.formattedName = formattedName;
    }

    public OtherNameIndividual fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Schema(description="Full name flatten (first, middle, and last names)")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public OtherNameIndividual generation(String generation) {
        this.generation = generation;
        return this;
    }

    @Schema(description="e.g. Sr, Jr\u2026")
    public String getGeneration() {
        return this.generation;
    }

    public void setGeneration(String generation) {
        this.generation = generation;
    }

    public OtherNameIndividual givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Schema(description="First name")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public OtherNameIndividual legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Schema(description="Legal name or birth name (name one has for official purposes)")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public OtherNameIndividual middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    @Schema(description="Middle name or initial")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public OtherNameIndividual preferredGivenName(String preferredGivenName) {
        this.preferredGivenName = preferredGivenName;
        return this;
    }

    @Schema(description="Contains the chosen name by which the person prefers to be addressed. Note: This name may be a name other than a given name, such as a nickname")
    public String getPreferredGivenName() {
        return this.preferredGivenName;
    }

    public void setPreferredGivenName(String preferredGivenName) {
        this.preferredGivenName = preferredGivenName;
    }

    public OtherNameIndividual title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="Use for titles (aristrocatic, social, ...): Pr, Dr, Sir,....")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public OtherNameIndividual validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtherNameIndividual otherNameIndividual = (OtherNameIndividual)o;
        return Objects.equals(this.aristocraticTitle, otherNameIndividual.aristocraticTitle) && Objects.equals(this.familyName, otherNameIndividual.familyName) && Objects.equals(this.familyNamePrefix, otherNameIndividual.familyNamePrefix) && Objects.equals(this.formattedName, otherNameIndividual.formattedName) && Objects.equals(this.fullName, otherNameIndividual.fullName) && Objects.equals(this.generation, otherNameIndividual.generation) && Objects.equals(this.givenName, otherNameIndividual.givenName) && Objects.equals(this.legalName, otherNameIndividual.legalName) && Objects.equals(this.middleName, otherNameIndividual.middleName) && Objects.equals(this.preferredGivenName, otherNameIndividual.preferredGivenName) && Objects.equals(this.title, otherNameIndividual.title) && Objects.equals(this.validFor, otherNameIndividual.validFor) && Objects.equals(this.baseType, otherNameIndividual.baseType) && Objects.equals(this.schemaLocation, otherNameIndividual.schemaLocation) && Objects.equals(this.type, otherNameIndividual.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtherNameIndividual {\n");
        sb.append("    aristocraticTitle: ").append(this.toIndentedString(this.aristocraticTitle)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    familyNamePrefix: ").append(this.toIndentedString(this.familyNamePrefix)).append("\n");
        sb.append("    formattedName: ").append(this.toIndentedString(this.formattedName)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    generation: ").append(this.toIndentedString(this.generation)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    middleName: ").append(this.toIndentedString(this.middleName)).append("\n");
        sb.append("    preferredGivenName: ").append(this.toIndentedString(this.preferredGivenName)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

