/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.ContactMedium;
import org.etsi.osl.tmf.pm632.model.ExternalReference;
import org.etsi.osl.tmf.pm632.model.OrganizationChildRelationship;
import org.etsi.osl.tmf.pm632.model.OrganizationIdentification;
import org.etsi.osl.tmf.pm632.model.OrganizationParentRelationship;
import org.etsi.osl.tmf.pm632.model.OrganizationStateType;
import org.etsi.osl.tmf.pm632.model.OtherNameOrganization;
import org.etsi.osl.tmf.pm632.model.PartyCreditProfile;
import org.etsi.osl.tmf.pm632.model.TaxExemptionCertificate;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="Organization represents a group of people identified by shared interests or purpose. Examples include business, department and enterprise. Because of the complex nature of many businesses, both organizations and organization units are represented by the same data. Skipped properties: id,href")
@Validated
public class OrganizationUpdate {
    @JsonProperty(value="isHeadOffice")
    protected Boolean isHeadOffice = null;
    @JsonProperty(value="isLegalEntity")
    protected Boolean isLegalEntity = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="nameType")
    protected String nameType = null;
    @JsonProperty(value="organizationType")
    protected String organizationType = null;
    @JsonProperty(value="tradingName")
    protected String tradingName = null;
    @JsonProperty(value="contactMedium")
    @Valid
    protected List<ContactMedium> contactMedium = null;
    @JsonProperty(value="creditRating")
    @Valid
    protected List<PartyCreditProfile> creditRating = null;
    @JsonProperty(value="existsDuring")
    protected TimePeriod existsDuring = null;
    @JsonProperty(value="externalReference")
    @Valid
    protected List<ExternalReference> externalReference = null;
    @JsonProperty(value="organizationChildRelationship")
    @Valid
    protected List<OrganizationChildRelationship> organizationChildRelationship = null;
    @JsonProperty(value="organizationIdentification")
    @Valid
    protected List<OrganizationIdentification> organizationIdentification = null;
    @JsonProperty(value="organizationParentRelationship")
    protected OrganizationParentRelationship organizationParentRelationship = null;
    @JsonProperty(value="otherName")
    @Valid
    protected List<OtherNameOrganization> otherName = null;
    @JsonProperty(value="partyCharacteristic")
    @Valid
    protected List<Characteristic> partyCharacteristic = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="status")
    protected OrganizationStateType status = null;
    @JsonProperty(value="taxExemptionCertificate")
    @Valid
    protected List<TaxExemptionCertificate> taxExemptionCertificate = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public OrganizationUpdate isHeadOffice(Boolean isHeadOffice) {
        this.isHeadOffice = isHeadOffice;
        return this;
    }

    @Schema(description="If value is true, the organization is the head office")
    public Boolean isIsHeadOffice() {
        return this.isHeadOffice;
    }

    public void setIsHeadOffice(Boolean isHeadOffice) {
        this.isHeadOffice = isHeadOffice;
    }

    public OrganizationUpdate isLegalEntity(Boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
        return this;
    }

    @Schema(description="If value is true, the organization is a legal entity known by a national referential.")
    public Boolean isIsLegalEntity() {
        return this.isLegalEntity;
    }

    public void setIsLegalEntity(Boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
    }

    public OrganizationUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Organization name (department name for example)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrganizationUpdate nameType(String nameType) {
        this.nameType = nameType;
        return this;
    }

    @Schema(description="Type of the name : Co, Inc, Ltd,\u2026")
    public String getNameType() {
        return this.nameType;
    }

    public void setNameType(String nameType) {
        this.nameType = nameType;
    }

    public OrganizationUpdate organizationType(String organizationType) {
        this.organizationType = organizationType;
        return this;
    }

    @Schema(description="Type of Organization (company, department...)")
    public String getOrganizationType() {
        return this.organizationType;
    }

    public void setOrganizationType(String organizationType) {
        this.organizationType = organizationType;
    }

    public OrganizationUpdate tradingName(String tradingName) {
        this.tradingName = tradingName;
        return this;
    }

    @Schema(description="Name that the organization (unit) trades under")
    public String getTradingName() {
        return this.tradingName;
    }

    public void setTradingName(String tradingName) {
        this.tradingName = tradingName;
    }

    public OrganizationUpdate contactMedium(List<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
        return this;
    }

    public OrganizationUpdate addContactMediumItem(ContactMedium contactMediumItem) {
        if (this.contactMedium == null) {
            this.contactMedium = new ArrayList<ContactMedium>();
        }
        this.contactMedium.add(contactMediumItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ContactMedium> getContactMedium() {
        return this.contactMedium;
    }

    public void setContactMedium(List<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
    }

    public OrganizationUpdate creditRating(List<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
        return this;
    }

    public OrganizationUpdate addCreditRatingItem(PartyCreditProfile creditRatingItem) {
        if (this.creditRating == null) {
            this.creditRating = new ArrayList<PartyCreditProfile>();
        }
        this.creditRating.add(creditRatingItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<PartyCreditProfile> getCreditRating() {
        return this.creditRating;
    }

    public void setCreditRating(List<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
    }

    public OrganizationUpdate existsDuring(TimePeriod existsDuring) {
        this.existsDuring = existsDuring;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getExistsDuring() {
        return this.existsDuring;
    }

    public void setExistsDuring(TimePeriod existsDuring) {
        this.existsDuring = existsDuring;
    }

    public OrganizationUpdate externalReference(List<ExternalReference> externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public OrganizationUpdate addExternalReferenceItem(ExternalReference externalReferenceItem) {
        if (this.externalReference == null) {
            this.externalReference = new ArrayList<ExternalReference>();
        }
        this.externalReference.add(externalReferenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(List<ExternalReference> externalReference) {
        this.externalReference = externalReference;
    }

    public OrganizationUpdate organizationChildRelationship(List<OrganizationChildRelationship> organizationChildRelationship) {
        this.organizationChildRelationship = organizationChildRelationship;
        return this;
    }

    public OrganizationUpdate addOrganizationChildRelationshipItem(OrganizationChildRelationship organizationChildRelationshipItem) {
        if (this.organizationChildRelationship == null) {
            this.organizationChildRelationship = new ArrayList<OrganizationChildRelationship>();
        }
        this.organizationChildRelationship.add(organizationChildRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<OrganizationChildRelationship> getOrganizationChildRelationship() {
        return this.organizationChildRelationship;
    }

    public void setOrganizationChildRelationship(List<OrganizationChildRelationship> organizationChildRelationship) {
        this.organizationChildRelationship = organizationChildRelationship;
    }

    public OrganizationUpdate organizationIdentification(List<OrganizationIdentification> organizationIdentification) {
        this.organizationIdentification = organizationIdentification;
        return this;
    }

    public OrganizationUpdate addOrganizationIdentificationItem(OrganizationIdentification organizationIdentificationItem) {
        if (this.organizationIdentification == null) {
            this.organizationIdentification = new ArrayList<OrganizationIdentification>();
        }
        this.organizationIdentification.add(organizationIdentificationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<OrganizationIdentification> getOrganizationIdentification() {
        return this.organizationIdentification;
    }

    public void setOrganizationIdentification(List<OrganizationIdentification> organizationIdentification) {
        this.organizationIdentification = organizationIdentification;
    }

    public OrganizationUpdate organizationParentRelationship(OrganizationParentRelationship organizationParentRelationship) {
        this.organizationParentRelationship = organizationParentRelationship;
        return this;
    }

    @Schema(description="")
    @Valid
    public OrganizationParentRelationship getOrganizationParentRelationship() {
        return this.organizationParentRelationship;
    }

    public void setOrganizationParentRelationship(OrganizationParentRelationship organizationParentRelationship) {
        this.organizationParentRelationship = organizationParentRelationship;
    }

    public OrganizationUpdate otherName(List<OtherNameOrganization> otherName) {
        this.otherName = otherName;
        return this;
    }

    public OrganizationUpdate addOtherNameItem(OtherNameOrganization otherNameItem) {
        if (this.otherName == null) {
            this.otherName = new ArrayList<OtherNameOrganization>();
        }
        this.otherName.add(otherNameItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<OtherNameOrganization> getOtherName() {
        return this.otherName;
    }

    public void setOtherName(List<OtherNameOrganization> otherName) {
        this.otherName = otherName;
    }

    public OrganizationUpdate partyCharacteristic(List<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
        return this;
    }

    public OrganizationUpdate addPartyCharacteristicItem(Characteristic partyCharacteristicItem) {
        if (this.partyCharacteristic == null) {
            this.partyCharacteristic = new ArrayList<Characteristic>();
        }
        this.partyCharacteristic.add(partyCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Characteristic> getPartyCharacteristic() {
        return this.partyCharacteristic;
    }

    public void setPartyCharacteristic(List<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
    }

    public OrganizationUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public OrganizationUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public OrganizationUpdate status(OrganizationStateType status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the organization")
    @Valid
    public OrganizationStateType getStatus() {
        return this.status;
    }

    public void setStatus(OrganizationStateType status) {
        this.status = status;
    }

    public OrganizationUpdate taxExemptionCertificate(List<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
        return this;
    }

    public OrganizationUpdate addTaxExemptionCertificateItem(TaxExemptionCertificate taxExemptionCertificateItem) {
        if (this.taxExemptionCertificate == null) {
            this.taxExemptionCertificate = new ArrayList<TaxExemptionCertificate>();
        }
        this.taxExemptionCertificate.add(taxExemptionCertificateItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<TaxExemptionCertificate> getTaxExemptionCertificate() {
        return this.taxExemptionCertificate;
    }

    public void setTaxExemptionCertificate(List<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
    }

    public OrganizationUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public OrganizationUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public OrganizationUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationUpdate organizationUpdate = (OrganizationUpdate)o;
        return Objects.equals(this.isHeadOffice, organizationUpdate.isHeadOffice) && Objects.equals(this.isLegalEntity, organizationUpdate.isLegalEntity) && Objects.equals(this.name, organizationUpdate.name) && Objects.equals(this.nameType, organizationUpdate.nameType) && Objects.equals(this.organizationType, organizationUpdate.organizationType) && Objects.equals(this.tradingName, organizationUpdate.tradingName) && Objects.equals(this.contactMedium, organizationUpdate.contactMedium) && Objects.equals(this.creditRating, organizationUpdate.creditRating) && Objects.equals(this.existsDuring, organizationUpdate.existsDuring) && Objects.equals(this.externalReference, organizationUpdate.externalReference) && Objects.equals(this.organizationChildRelationship, organizationUpdate.organizationChildRelationship) && Objects.equals(this.organizationIdentification, organizationUpdate.organizationIdentification) && Objects.equals(this.organizationParentRelationship, organizationUpdate.organizationParentRelationship) && Objects.equals(this.otherName, organizationUpdate.otherName) && Objects.equals(this.partyCharacteristic, organizationUpdate.partyCharacteristic) && Objects.equals(this.relatedParty, organizationUpdate.relatedParty) && Objects.equals((Object)this.status, (Object)organizationUpdate.status) && Objects.equals(this.taxExemptionCertificate, organizationUpdate.taxExemptionCertificate) && Objects.equals(this.baseType, organizationUpdate.baseType) && Objects.equals(this.schemaLocation, organizationUpdate.schemaLocation) && Objects.equals(this.type, organizationUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isHeadOffice, this.isLegalEntity, this.name, this.nameType, this.organizationType, this.tradingName, this.contactMedium, this.creditRating, this.existsDuring, this.externalReference, this.organizationChildRelationship, this.organizationIdentification, this.organizationParentRelationship, this.otherName, this.partyCharacteristic, this.relatedParty, this.status, this.taxExemptionCertificate, this.baseType, this.schemaLocation, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationUpdate {\n");
        sb.append("    isHeadOffice: ").append(this.toIndentedString(this.isHeadOffice)).append("\n");
        sb.append("    isLegalEntity: ").append(this.toIndentedString(this.isLegalEntity)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameType: ").append(this.toIndentedString(this.nameType)).append("\n");
        sb.append("    organizationType: ").append(this.toIndentedString(this.organizationType)).append("\n");
        sb.append("    tradingName: ").append(this.toIndentedString(this.tradingName)).append("\n");
        sb.append("    contactMedium: ").append(this.toIndentedString(this.contactMedium)).append("\n");
        sb.append("    creditRating: ").append(this.toIndentedString(this.creditRating)).append("\n");
        sb.append("    existsDuring: ").append(this.toIndentedString(this.existsDuring)).append("\n");
        sb.append("    externalReference: ").append(this.toIndentedString(this.externalReference)).append("\n");
        sb.append("    organizationChildRelationship: ").append(this.toIndentedString(this.organizationChildRelationship)).append("\n");
        sb.append("    organizationIdentification: ").append(this.toIndentedString(this.organizationIdentification)).append("\n");
        sb.append("    organizationParentRelationship: ").append(this.toIndentedString(this.organizationParentRelationship)).append("\n");
        sb.append("    otherName: ").append(this.toIndentedString(this.otherName)).append("\n");
        sb.append("    partyCharacteristic: ").append(this.toIndentedString(this.partyCharacteristic)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    taxExemptionCertificate: ").append(this.toIndentedString(this.taxExemptionCertificate)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Characteristic findCharacteristic(String aName) {
        if (this.partyCharacteristic != null) {
            for (Characteristic c : this.partyCharacteristic) {
                if (!c.getName().equals(aName)) continue;
                return c;
            }
        }
        return null;
    }
}

