/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Validated
@Entity
public class OrganizationRef
extends BaseRootNamedEntity {
    @JsonProperty(value="@referredType")
    private String referredType = null;

    @Schema(description="Unique identifier of a related entity.")
    @NotNull
    @JsonProperty(value="id")
    public String getId() {
        return this.uuid;
    }

    public OrganizationRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationRef organizationRef = (OrganizationRef)o;
        return Objects.equals(this.uuid, organizationRef.uuid) && Objects.equals(this.href, organizationRef.href) && Objects.equals(this.name, organizationRef.name) && Objects.equals(this.baseType, organizationRef.baseType) && Objects.equals(this.schemaLocation, organizationRef.schemaLocation) && Objects.equals(this.type, organizationRef.type) && Objects.equals(this.referredType, organizationRef.referredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uuid, this.href, this.name, this.baseType, this.schemaLocation, this.type, this.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

