/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pm632.model.OrganizationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Parent references of an organization in a structure of organizations.")
@Validated
@Entity
public class OrganizationParentRelationship
extends BaseRootNamedEntity {
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="organization")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="organizationref_refid", referencedColumnName="uuid")
    private OrganizationRef organization = null;

    public OrganizationParentRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of the relationship. Could be juridical, hierarchical, geographical, functional for example.")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public OrganizationParentRelationship organization(OrganizationRef organization) {
        this.organization = organization;
        return this;
    }

    @Schema(description="")
    @Valid
    public OrganizationRef getOrganization() {
        return this.organization;
    }

    public void setOrganization(OrganizationRef organization) {
        this.organization = organization;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationParentRelationship organizationParentRelationship = (OrganizationParentRelationship)o;
        return Objects.equals(this.relationshipType, organizationParentRelationship.relationshipType) && Objects.equals(this.organization, organizationParentRelationship.organization) && Objects.equals(this.baseType, organizationParentRelationship.baseType) && Objects.equals(this.schemaLocation, organizationParentRelationship.schemaLocation) && Objects.equals(this.type, organizationParentRelationship.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationParentRelationship {\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

