/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.ContactMedium;
import org.etsi.osl.tmf.pm632.model.ExternalReference;
import org.etsi.osl.tmf.pm632.model.OrganizationChildRelationship;
import org.etsi.osl.tmf.pm632.model.OrganizationIdentification;
import org.etsi.osl.tmf.pm632.model.OrganizationParentRelationship;
import org.etsi.osl.tmf.pm632.model.OrganizationStateType;
import org.etsi.osl.tmf.pm632.model.OtherNameOrganization;
import org.etsi.osl.tmf.pm632.model.PartyCreditProfile;
import org.etsi.osl.tmf.pm632.model.TaxExemptionCertificate;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="Organization represents a group of people identified by shared interests or purpose. Examples include business, department and enterprise. Because of the complex nature of many businesses, both organizations and organization units are represented by the same data.")
@Validated
@Entity
public class Organization
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="isHeadOffice")
    private Boolean isHeadOffice = null;
    @JsonProperty(value="isLegalEntity")
    private Boolean isLegalEntity = null;
    @JsonProperty(value="nameType")
    private String nameType = null;
    @JsonProperty(value="organizationType")
    private String organizationType = null;
    @JsonProperty(value="tradingName")
    private String tradingName = null;
    @JsonProperty(value="contactMedium")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ContactMedium> contactMedium = new HashSet<ContactMedium>();
    @JsonProperty(value="creditRating")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PartyCreditProfile> creditRating = new HashSet<PartyCreditProfile>();
    @JsonProperty(value="existsDuring")
    private TimePeriod existsDuring = null;
    @JsonProperty(value="externalReference")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ExternalReference> externalReference = new HashSet<ExternalReference>();
    @JsonProperty(value="organizationChildRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OrganizationChildRelationship> organizationChildRelationship = new HashSet<OrganizationChildRelationship>();
    @JsonProperty(value="organizationIdentification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OrganizationIdentification> organizationIdentification = new HashSet<OrganizationIdentification>();
    @JsonProperty(value="organizationParentRelationship")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="organization_parentrel_refid", referencedColumnName="uuid")
    private OrganizationParentRelationship organizationParentRelationship = null;
    @JsonProperty(value="otherName")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OtherNameOrganization> otherName = new HashSet<OtherNameOrganization>();
    @JsonProperty(value="partyCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Characteristic> partyCharacteristic = new HashSet<Characteristic>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="status")
    private OrganizationStateType status = null;
    @JsonProperty(value="taxExemptionCertificate")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<TaxExemptionCertificate> taxExemptionCertificate = new HashSet<TaxExemptionCertificate>();

    @Schema(description="Unique identifier of the organization")
    public String getId() {
        return this.uuid;
    }

    public Organization isHeadOffice(Boolean isHeadOffice) {
        this.isHeadOffice = isHeadOffice;
        return this;
    }

    @Schema(description="If value is true, the organization is the head office")
    public Boolean isIsHeadOffice() {
        return this.isHeadOffice;
    }

    public void setIsHeadOffice(Boolean isHeadOffice) {
        this.isHeadOffice = isHeadOffice;
    }

    public Organization isLegalEntity(Boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
        return this;
    }

    @Schema(description="If value is true, the organization is a legal entity known by a national referential.")
    public Boolean isIsLegalEntity() {
        return this.isLegalEntity;
    }

    public void setIsLegalEntity(Boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
    }

    public Organization nameType(String nameType) {
        this.nameType = nameType;
        return this;
    }

    @Schema(description="Type of the name : Co, Inc, Ltd,\u2026")
    public String getNameType() {
        return this.nameType;
    }

    public void setNameType(String nameType) {
        this.nameType = nameType;
    }

    public Organization organizationType(String organizationType) {
        this.organizationType = organizationType;
        return this;
    }

    @Schema(description="Type of Organization (company, department...)")
    public String getOrganizationType() {
        return this.organizationType;
    }

    public void setOrganizationType(String organizationType) {
        this.organizationType = organizationType;
    }

    public Organization tradingName(String tradingName) {
        this.tradingName = tradingName;
        return this;
    }

    @Schema(description="Name that the organization (unit) trades under")
    public String getTradingName() {
        return this.tradingName;
    }

    public void setTradingName(String tradingName) {
        this.tradingName = tradingName;
    }

    public Organization contactMedium(Set<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
        return this;
    }

    public Organization addContactMediumItem(ContactMedium contactMediumItem) {
        if (this.contactMedium == null) {
            this.contactMedium = new HashSet<ContactMedium>();
        }
        this.contactMedium.add(contactMediumItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ContactMedium> getContactMedium() {
        return this.contactMedium;
    }

    public void setContactMedium(Set<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
    }

    public Organization creditRating(Set<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
        return this;
    }

    public Organization addCreditRatingItem(PartyCreditProfile creditRatingItem) {
        if (this.creditRating == null) {
            this.creditRating = new HashSet<PartyCreditProfile>();
        }
        this.creditRating.add(creditRatingItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<PartyCreditProfile> getCreditRating() {
        return this.creditRating;
    }

    public void setCreditRating(Set<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
    }

    public Organization existsDuring(TimePeriod existsDuring) {
        this.existsDuring = existsDuring;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getExistsDuring() {
        return this.existsDuring;
    }

    public void setExistsDuring(TimePeriod existsDuring) {
        this.existsDuring = existsDuring;
    }

    public Organization externalReference(Set<ExternalReference> externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public Organization addExternalReferenceItem(ExternalReference externalReferenceItem) {
        if (this.externalReference == null) {
            this.externalReference = new HashSet<ExternalReference>();
        }
        this.externalReference.add(externalReferenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(Set<ExternalReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Organization organizationChildRelationship(Set<OrganizationChildRelationship> organizationChildRelationship) {
        this.organizationChildRelationship = organizationChildRelationship;
        return this;
    }

    public Organization addOrganizationChildRelationshipItem(OrganizationChildRelationship organizationChildRelationshipItem) {
        if (this.organizationChildRelationship == null) {
            this.organizationChildRelationship = new HashSet<OrganizationChildRelationship>();
        }
        this.organizationChildRelationship.add(organizationChildRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OrganizationChildRelationship> getOrganizationChildRelationship() {
        return this.organizationChildRelationship;
    }

    public void setOrganizationChildRelationship(Set<OrganizationChildRelationship> organizationChildRelationship) {
        this.organizationChildRelationship = organizationChildRelationship;
    }

    public Organization organizationIdentification(Set<OrganizationIdentification> organizationIdentification) {
        this.organizationIdentification = organizationIdentification;
        return this;
    }

    public Organization addOrganizationIdentificationItem(OrganizationIdentification organizationIdentificationItem) {
        if (this.organizationIdentification == null) {
            this.organizationIdentification = new HashSet<OrganizationIdentification>();
        }
        this.organizationIdentification.add(organizationIdentificationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OrganizationIdentification> getOrganizationIdentification() {
        return this.organizationIdentification;
    }

    public void setOrganizationIdentification(Set<OrganizationIdentification> organizationIdentification) {
        this.organizationIdentification = organizationIdentification;
    }

    public Organization organizationParentRelationship(OrganizationParentRelationship organizationParentRelationship) {
        this.organizationParentRelationship = organizationParentRelationship;
        return this;
    }

    @Schema(description="")
    @Valid
    public OrganizationParentRelationship getOrganizationParentRelationship() {
        return this.organizationParentRelationship;
    }

    public void setOrganizationParentRelationship(OrganizationParentRelationship organizationParentRelationship) {
        this.organizationParentRelationship = organizationParentRelationship;
    }

    public Organization otherName(Set<OtherNameOrganization> otherName) {
        this.otherName = otherName;
        return this;
    }

    public Organization addOtherNameItem(OtherNameOrganization otherNameItem) {
        if (this.otherName == null) {
            this.otherName = new HashSet<OtherNameOrganization>();
        }
        this.otherName.add(otherNameItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OtherNameOrganization> getOtherName() {
        return this.otherName;
    }

    public void setOtherName(Set<OtherNameOrganization> otherName) {
        this.otherName = otherName;
    }

    public Organization partyCharacteristic(Set<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
        return this;
    }

    public Organization addPartyCharacteristicItem(Characteristic partyCharacteristicItem) {
        if (this.partyCharacteristic == null) {
            this.partyCharacteristic = new HashSet<Characteristic>();
        }
        this.partyCharacteristic.add(partyCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Characteristic> getPartyCharacteristic() {
        return this.partyCharacteristic;
    }

    public void setPartyCharacteristic(Set<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
    }

    public Organization relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Organization addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Organization status(OrganizationStateType status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the organization")
    @Valid
    public OrganizationStateType getStatus() {
        return this.status;
    }

    public void setStatus(OrganizationStateType status) {
        this.status = status;
    }

    public Organization taxExemptionCertificate(Set<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
        return this;
    }

    public Organization addTaxExemptionCertificateItem(TaxExemptionCertificate taxExemptionCertificateItem) {
        if (this.taxExemptionCertificate == null) {
            this.taxExemptionCertificate = new HashSet<TaxExemptionCertificate>();
        }
        this.taxExemptionCertificate.add(taxExemptionCertificateItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<TaxExemptionCertificate> getTaxExemptionCertificate() {
        return this.taxExemptionCertificate;
    }

    public void setTaxExemptionCertificate(Set<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.uuid, organization.uuid) && Objects.equals(this.href, organization.href) && Objects.equals(this.isHeadOffice, organization.isHeadOffice) && Objects.equals(this.isLegalEntity, organization.isLegalEntity) && Objects.equals(this.name, organization.name) && Objects.equals(this.nameType, organization.nameType) && Objects.equals(this.organizationType, organization.organizationType) && Objects.equals(this.tradingName, organization.tradingName) && Objects.equals(this.contactMedium, organization.contactMedium) && Objects.equals(this.creditRating, organization.creditRating) && Objects.equals(this.existsDuring, organization.existsDuring) && Objects.equals(this.externalReference, organization.externalReference) && Objects.equals(this.organizationChildRelationship, organization.organizationChildRelationship) && Objects.equals(this.organizationIdentification, organization.organizationIdentification) && Objects.equals(this.organizationParentRelationship, organization.organizationParentRelationship) && Objects.equals(this.otherName, organization.otherName) && Objects.equals(this.partyCharacteristic, organization.partyCharacteristic) && Objects.equals(this.relatedParty, organization.relatedParty) && Objects.equals((Object)this.status, (Object)organization.status) && Objects.equals(this.taxExemptionCertificate, organization.taxExemptionCertificate) && Objects.equals(this.baseType, organization.baseType) && Objects.equals(this.schemaLocation, organization.schemaLocation) && Objects.equals(this.type, organization.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    isHeadOffice: ").append(this.toIndentedString(this.isHeadOffice)).append("\n");
        sb.append("    isLegalEntity: ").append(this.toIndentedString(this.isLegalEntity)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameType: ").append(this.toIndentedString(this.nameType)).append("\n");
        sb.append("    organizationType: ").append(this.toIndentedString(this.organizationType)).append("\n");
        sb.append("    tradingName: ").append(this.toIndentedString(this.tradingName)).append("\n");
        sb.append("    contactMedium: ").append(this.toIndentedString(this.contactMedium)).append("\n");
        sb.append("    creditRating: ").append(this.toIndentedString(this.creditRating)).append("\n");
        sb.append("    existsDuring: ").append(this.toIndentedString(this.existsDuring)).append("\n");
        sb.append("    externalReference: ").append(this.toIndentedString(this.externalReference)).append("\n");
        sb.append("    organizationChildRelationship: ").append(this.toIndentedString(this.organizationChildRelationship)).append("\n");
        sb.append("    organizationIdentification: ").append(this.toIndentedString(this.organizationIdentification)).append("\n");
        sb.append("    organizationParentRelationship: ").append(this.toIndentedString(this.organizationParentRelationship)).append("\n");
        sb.append("    otherName: ").append(this.toIndentedString(this.otherName)).append("\n");
        sb.append("    partyCharacteristic: ").append(this.toIndentedString(this.partyCharacteristic)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    taxExemptionCertificate: ").append(this.toIndentedString(this.taxExemptionCertificate)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Characteristic findPartyCharacteristic(String name) {
        for (Characteristic c : this.partyCharacteristic) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }
}

