/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Ability of an individual to understand or converse in a language.")
@Validated
@Entity
public class LanguageAbility
extends BaseRootEntity {
    @JsonProperty(value="isFavouriteLanguage")
    private Boolean isFavouriteLanguage = null;
    @JsonProperty(value="languageCode")
    private String languageCode = null;
    @JsonProperty(value="languageName")
    private String languageName = null;
    @JsonProperty(value="listeningProficiency")
    private String listeningProficiency = null;
    @JsonProperty(value="readingProficiency")
    private String readingProficiency = null;
    @JsonProperty(value="speakingProficiency")
    private String speakingProficiency = null;
    @JsonProperty(value="writingProficiency")
    private String writingProficiency = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public LanguageAbility isFavouriteLanguage(Boolean isFavouriteLanguage) {
        this.isFavouriteLanguage = isFavouriteLanguage;
        return this;
    }

    @Schema(description="A \u201ctrue\u201d value specifies whether the language is considered by the individual as his favourite one")
    public Boolean isIsFavouriteLanguage() {
        return this.isFavouriteLanguage;
    }

    public void setIsFavouriteLanguage(Boolean isFavouriteLanguage) {
        this.isFavouriteLanguage = isFavouriteLanguage;
    }

    public LanguageAbility languageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @Schema(description="Language code (RFC 5646)")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public LanguageAbility languageName(String languageName) {
        this.languageName = languageName;
        return this;
    }

    @Schema(description="Language name")
    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public LanguageAbility listeningProficiency(String listeningProficiency) {
        this.listeningProficiency = listeningProficiency;
        return this;
    }

    @Schema(description="Listening proficiency evaluated for this language")
    public String getListeningProficiency() {
        return this.listeningProficiency;
    }

    public void setListeningProficiency(String listeningProficiency) {
        this.listeningProficiency = listeningProficiency;
    }

    public LanguageAbility readingProficiency(String readingProficiency) {
        this.readingProficiency = readingProficiency;
        return this;
    }

    @Schema(description="Reading proficiency evaluated for this language")
    public String getReadingProficiency() {
        return this.readingProficiency;
    }

    public void setReadingProficiency(String readingProficiency) {
        this.readingProficiency = readingProficiency;
    }

    public LanguageAbility speakingProficiency(String speakingProficiency) {
        this.speakingProficiency = speakingProficiency;
        return this;
    }

    @Schema(description="Speaking proficiency evaluated for this language")
    public String getSpeakingProficiency() {
        return this.speakingProficiency;
    }

    public void setSpeakingProficiency(String speakingProficiency) {
        this.speakingProficiency = speakingProficiency;
    }

    public LanguageAbility writingProficiency(String writingProficiency) {
        this.writingProficiency = writingProficiency;
        return this;
    }

    @Schema(description="Writing proficiency evaluated for this language")
    public String getWritingProficiency() {
        return this.writingProficiency;
    }

    public void setWritingProficiency(String writingProficiency) {
        this.writingProficiency = writingProficiency;
    }

    public LanguageAbility validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageAbility languageAbility = (LanguageAbility)o;
        return Objects.equals(this.isFavouriteLanguage, languageAbility.isFavouriteLanguage) && Objects.equals(this.languageCode, languageAbility.languageCode) && Objects.equals(this.languageName, languageAbility.languageName) && Objects.equals(this.listeningProficiency, languageAbility.listeningProficiency) && Objects.equals(this.readingProficiency, languageAbility.readingProficiency) && Objects.equals(this.speakingProficiency, languageAbility.speakingProficiency) && Objects.equals(this.writingProficiency, languageAbility.writingProficiency) && Objects.equals(this.validFor, languageAbility.validFor) && Objects.equals(this.baseType, languageAbility.baseType) && Objects.equals(this.schemaLocation, languageAbility.schemaLocation) && Objects.equals(this.type, languageAbility.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LanguageAbility {\n");
        sb.append("    isFavouriteLanguage: ").append(this.toIndentedString(this.isFavouriteLanguage)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("    languageName: ").append(this.toIndentedString(this.languageName)).append("\n");
        sb.append("    listeningProficiency: ").append(this.toIndentedString(this.listeningProficiency)).append("\n");
        sb.append("    readingProficiency: ").append(this.toIndentedString(this.readingProficiency)).append("\n");
        sb.append("    speakingProficiency: ").append(this.toIndentedString(this.speakingProficiency)).append("\n");
        sb.append("    writingProficiency: ").append(this.toIndentedString(this.writingProficiency)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

