/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.ContactMedium;
import org.etsi.osl.tmf.pm632.model.Disability;
import org.etsi.osl.tmf.pm632.model.ExternalReference;
import org.etsi.osl.tmf.pm632.model.IndividualIdentification;
import org.etsi.osl.tmf.pm632.model.IndividualStateType;
import org.etsi.osl.tmf.pm632.model.LanguageAbility;
import org.etsi.osl.tmf.pm632.model.OtherNameIndividual;
import org.etsi.osl.tmf.pm632.model.PartyCreditProfile;
import org.etsi.osl.tmf.pm632.model.Skill;
import org.etsi.osl.tmf.pm632.model.TaxExemptionCertificate;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="Individual represents a single human being (a man, woman or child). The individual can be a customer, an employee or any other person that the organization needs to store information about. Skipped properties: id,href")
@Validated
public class IndividualUpdate {
    @JsonProperty(value="aristocraticTitle")
    protected String aristocraticTitle = null;
    protected OffsetDateTime birthDate = null;
    @JsonProperty(value="countryOfBirth")
    protected String countryOfBirth = null;
    protected OffsetDateTime deathDate = null;
    @JsonProperty(value="familyName")
    protected String familyName = null;
    @JsonProperty(value="familyNamePrefix")
    protected String familyNamePrefix = null;
    @JsonProperty(value="formattedName")
    protected String formattedName = null;
    @JsonProperty(value="fullName")
    protected String fullName = null;
    @JsonProperty(value="gender")
    protected String gender = null;
    @JsonProperty(value="generation")
    protected String generation = null;
    @JsonProperty(value="givenName")
    protected String givenName = null;
    @JsonProperty(value="legalName")
    protected String legalName = null;
    @JsonProperty(value="location")
    protected String location = null;
    @JsonProperty(value="maritalStatus")
    protected String maritalStatus = null;
    @JsonProperty(value="middleName")
    protected String middleName = null;
    @JsonProperty(value="nationality")
    protected String nationality = null;
    @JsonProperty(value="placeOfBirth")
    protected String placeOfBirth = null;
    @JsonProperty(value="preferredGivenName")
    protected String preferredGivenName = null;
    @JsonProperty(value="title")
    protected String title = null;
    @JsonProperty(value="contactMedium")
    @Valid
    protected List<ContactMedium> contactMedium = null;
    @JsonProperty(value="creditRating")
    @Valid
    protected List<PartyCreditProfile> creditRating = null;
    @JsonProperty(value="disability")
    @Valid
    protected List<Disability> disability = null;
    @JsonProperty(value="externalReference")
    @Valid
    protected List<ExternalReference> externalReference = null;
    @JsonProperty(value="individualIdentification")
    @Valid
    protected List<IndividualIdentification> individualIdentification = null;
    @JsonProperty(value="languageAbility")
    @Valid
    protected List<LanguageAbility> languageAbility = null;
    @JsonProperty(value="otherName")
    @Valid
    protected List<OtherNameIndividual> otherName = null;
    @JsonProperty(value="partyCharacteristic")
    @Valid
    protected List<Characteristic> partyCharacteristic = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="skill")
    @Valid
    protected List<Skill> skill = null;
    @JsonProperty(value="status")
    protected IndividualStateType status = null;
    @JsonProperty(value="taxExemptionCertificate")
    @Valid
    protected List<TaxExemptionCertificate> taxExemptionCertificate = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public IndividualUpdate aristocraticTitle(String aristocraticTitle) {
        this.aristocraticTitle = aristocraticTitle;
        return this;
    }

    @Schema(description="e.g. Baron, Graf, Earl,\u2026")
    public String getAristocraticTitle() {
        return this.aristocraticTitle;
    }

    public void setAristocraticTitle(String aristocraticTitle) {
        this.aristocraticTitle = aristocraticTitle;
    }

    public IndividualUpdate birthDate(OffsetDateTime birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    @Schema(description="Birth date")
    @Valid
    @JsonProperty(value="birthDate")
    public String getBirthDateString() {
        if (this.birthDate == null) {
            return null;
        }
        return this.birthDate.toString();
    }

    public OffsetDateTime getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(OffsetDateTime birthDate) {
        this.birthDate = birthDate;
    }

    public IndividualUpdate countryOfBirth(String countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
        return this;
    }

    @Schema(description="Country where the individual was born")
    public String getCountryOfBirth() {
        return this.countryOfBirth;
    }

    public void setCountryOfBirth(String countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
    }

    public IndividualUpdate deathDate(OffsetDateTime deathDate) {
        this.deathDate = deathDate;
        return this;
    }

    @Schema(description="Date of death")
    @Valid
    @JsonProperty(value="deathDate")
    public String getDeathDateString() {
        if (this.deathDate == null) {
            return null;
        }
        return this.deathDate.toString();
    }

    public OffsetDateTime getDeathDate() {
        return this.deathDate;
    }

    public void setDeathDate(OffsetDateTime deathDate) {
        this.deathDate = deathDate;
    }

    public IndividualUpdate familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Schema(description="Contains the non-chosen or inherited name. Also known as last name in the Western context")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public IndividualUpdate familyNamePrefix(String familyNamePrefix) {
        this.familyNamePrefix = familyNamePrefix;
        return this;
    }

    @Schema(description="Family name prefix")
    public String getFamilyNamePrefix() {
        return this.familyNamePrefix;
    }

    public void setFamilyNamePrefix(String familyNamePrefix) {
        this.familyNamePrefix = familyNamePrefix;
    }

    public IndividualUpdate formattedName(String formattedName) {
        this.formattedName = formattedName;
        return this;
    }

    @Schema(description="A fully formatted name in one string with all of its pieces in their proper place and all of the necessary punctuation. Useful for specific contexts (Chinese, Japanese, Korean,\u2026)")
    public String getFormattedName() {
        return this.formattedName;
    }

    public void setFormattedName(String formattedName) {
        this.formattedName = formattedName;
    }

    public IndividualUpdate fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Schema(description="Full name flatten (first, middle, and last names)")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public IndividualUpdate gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="Gender")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public IndividualUpdate generation(String generation) {
        this.generation = generation;
        return this;
    }

    @Schema(description="e.g.. Sr, Jr, III (the third),\u2026")
    public String getGeneration() {
        return this.generation;
    }

    public void setGeneration(String generation) {
        this.generation = generation;
    }

    public IndividualUpdate givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Schema(description="First name of the individual")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public IndividualUpdate legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Schema(description="Legal name or birth name (name one has for official purposes)")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public IndividualUpdate location(String location) {
        this.location = location;
        return this;
    }

    @Schema(description="Temporary current location od the individual (may be used if the individual has approved its sharing)")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public IndividualUpdate maritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
        return this;
    }

    @Schema(description="Marital status (married, divorced, widow ...)")
    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public IndividualUpdate middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    @Schema(description="Middles name or initial")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public IndividualUpdate nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @Schema(description="Nationality")
    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public IndividualUpdate placeOfBirth(String placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
        return this;
    }

    @Schema(description="Reference to the place where the individual was born")
    public String getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public void setPlaceOfBirth(String placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
    }

    public IndividualUpdate preferredGivenName(String preferredGivenName) {
        this.preferredGivenName = preferredGivenName;
        return this;
    }

    @Schema(description="Contains the chosen name by which the individual prefers to be addressed. Note: This name may be a name other than a given name, such as a nickname")
    public String getPreferredGivenName() {
        return this.preferredGivenName;
    }

    public void setPreferredGivenName(String preferredGivenName) {
        this.preferredGivenName = preferredGivenName;
    }

    public IndividualUpdate title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="Useful for titles (aristocratic, social,...) Pr, Dr, Sir, ...")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public IndividualUpdate contactMedium(List<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
        return this;
    }

    public IndividualUpdate addContactMediumItem(ContactMedium contactMediumItem) {
        if (this.contactMedium == null) {
            this.contactMedium = new ArrayList<ContactMedium>();
        }
        this.contactMedium.add(contactMediumItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ContactMedium> getContactMedium() {
        return this.contactMedium;
    }

    public void setContactMedium(List<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
    }

    public IndividualUpdate creditRating(List<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
        return this;
    }

    public IndividualUpdate addCreditRatingItem(PartyCreditProfile creditRatingItem) {
        if (this.creditRating == null) {
            this.creditRating = new ArrayList<PartyCreditProfile>();
        }
        this.creditRating.add(creditRatingItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<PartyCreditProfile> getCreditRating() {
        return this.creditRating;
    }

    public void setCreditRating(List<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
    }

    public IndividualUpdate disability(List<Disability> disability) {
        this.disability = disability;
        return this;
    }

    public IndividualUpdate addDisabilityItem(Disability disabilityItem) {
        if (this.disability == null) {
            this.disability = new ArrayList<Disability>();
        }
        this.disability.add(disabilityItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Disability> getDisability() {
        return this.disability;
    }

    public void setDisability(List<Disability> disability) {
        this.disability = disability;
    }

    public IndividualUpdate externalReference(List<ExternalReference> externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public IndividualUpdate addExternalReferenceItem(ExternalReference externalReferenceItem) {
        if (this.externalReference == null) {
            this.externalReference = new ArrayList<ExternalReference>();
        }
        this.externalReference.add(externalReferenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(List<ExternalReference> externalReference) {
        this.externalReference = externalReference;
    }

    public IndividualUpdate individualIdentification(List<IndividualIdentification> individualIdentification) {
        this.individualIdentification = individualIdentification;
        return this;
    }

    public IndividualUpdate addIndividualIdentificationItem(IndividualIdentification individualIdentificationItem) {
        if (this.individualIdentification == null) {
            this.individualIdentification = new ArrayList<IndividualIdentification>();
        }
        this.individualIdentification.add(individualIdentificationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<IndividualIdentification> getIndividualIdentification() {
        return this.individualIdentification;
    }

    public void setIndividualIdentification(List<IndividualIdentification> individualIdentification) {
        this.individualIdentification = individualIdentification;
    }

    public IndividualUpdate languageAbility(List<LanguageAbility> languageAbility) {
        this.languageAbility = languageAbility;
        return this;
    }

    public IndividualUpdate addLanguageAbilityItem(LanguageAbility languageAbilityItem) {
        if (this.languageAbility == null) {
            this.languageAbility = new ArrayList<LanguageAbility>();
        }
        this.languageAbility.add(languageAbilityItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<LanguageAbility> getLanguageAbility() {
        return this.languageAbility;
    }

    public void setLanguageAbility(List<LanguageAbility> languageAbility) {
        this.languageAbility = languageAbility;
    }

    public IndividualUpdate otherName(List<OtherNameIndividual> otherName) {
        this.otherName = otherName;
        return this;
    }

    public IndividualUpdate addOtherNameItem(OtherNameIndividual otherNameItem) {
        if (this.otherName == null) {
            this.otherName = new ArrayList<OtherNameIndividual>();
        }
        this.otherName.add(otherNameItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<OtherNameIndividual> getOtherName() {
        return this.otherName;
    }

    public void setOtherName(List<OtherNameIndividual> otherName) {
        this.otherName = otherName;
    }

    public IndividualUpdate partyCharacteristic(List<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
        return this;
    }

    public IndividualUpdate addPartyCharacteristicItem(Characteristic partyCharacteristicItem) {
        if (this.partyCharacteristic == null) {
            this.partyCharacteristic = new ArrayList<Characteristic>();
        }
        this.partyCharacteristic.add(partyCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Characteristic> getPartyCharacteristic() {
        return this.partyCharacteristic;
    }

    public void setPartyCharacteristic(List<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
    }

    public IndividualUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public IndividualUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public IndividualUpdate skill(List<Skill> skill) {
        this.skill = skill;
        return this;
    }

    public IndividualUpdate addSkillItem(Skill skillItem) {
        if (this.skill == null) {
            this.skill = new ArrayList<Skill>();
        }
        this.skill.add(skillItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Skill> getSkill() {
        return this.skill;
    }

    public void setSkill(List<Skill> skill) {
        this.skill = skill;
    }

    public IndividualUpdate status(IndividualStateType status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the individual")
    @Valid
    public IndividualStateType getStatus() {
        return this.status;
    }

    public void setStatus(IndividualStateType status) {
        this.status = status;
    }

    public IndividualUpdate taxExemptionCertificate(List<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
        return this;
    }

    public IndividualUpdate addTaxExemptionCertificateItem(TaxExemptionCertificate taxExemptionCertificateItem) {
        if (this.taxExemptionCertificate == null) {
            this.taxExemptionCertificate = new ArrayList<TaxExemptionCertificate>();
        }
        this.taxExemptionCertificate.add(taxExemptionCertificateItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<TaxExemptionCertificate> getTaxExemptionCertificate() {
        return this.taxExemptionCertificate;
    }

    public void setTaxExemptionCertificate(List<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
    }

    public IndividualUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public IndividualUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public IndividualUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndividualUpdate individualUpdate = (IndividualUpdate)o;
        return Objects.equals(this.aristocraticTitle, individualUpdate.aristocraticTitle) && Objects.equals(this.birthDate, individualUpdate.birthDate) && Objects.equals(this.countryOfBirth, individualUpdate.countryOfBirth) && Objects.equals(this.deathDate, individualUpdate.deathDate) && Objects.equals(this.familyName, individualUpdate.familyName) && Objects.equals(this.familyNamePrefix, individualUpdate.familyNamePrefix) && Objects.equals(this.formattedName, individualUpdate.formattedName) && Objects.equals(this.fullName, individualUpdate.fullName) && Objects.equals(this.gender, individualUpdate.gender) && Objects.equals(this.generation, individualUpdate.generation) && Objects.equals(this.givenName, individualUpdate.givenName) && Objects.equals(this.legalName, individualUpdate.legalName) && Objects.equals(this.location, individualUpdate.location) && Objects.equals(this.maritalStatus, individualUpdate.maritalStatus) && Objects.equals(this.middleName, individualUpdate.middleName) && Objects.equals(this.nationality, individualUpdate.nationality) && Objects.equals(this.placeOfBirth, individualUpdate.placeOfBirth) && Objects.equals(this.preferredGivenName, individualUpdate.preferredGivenName) && Objects.equals(this.title, individualUpdate.title) && Objects.equals(this.contactMedium, individualUpdate.contactMedium) && Objects.equals(this.creditRating, individualUpdate.creditRating) && Objects.equals(this.disability, individualUpdate.disability) && Objects.equals(this.externalReference, individualUpdate.externalReference) && Objects.equals(this.individualIdentification, individualUpdate.individualIdentification) && Objects.equals(this.languageAbility, individualUpdate.languageAbility) && Objects.equals(this.otherName, individualUpdate.otherName) && Objects.equals(this.partyCharacteristic, individualUpdate.partyCharacteristic) && Objects.equals(this.relatedParty, individualUpdate.relatedParty) && Objects.equals(this.skill, individualUpdate.skill) && Objects.equals((Object)this.status, (Object)individualUpdate.status) && Objects.equals(this.taxExemptionCertificate, individualUpdate.taxExemptionCertificate) && Objects.equals(this.baseType, individualUpdate.baseType) && Objects.equals(this.schemaLocation, individualUpdate.schemaLocation) && Objects.equals(this.type, individualUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aristocraticTitle, this.birthDate, this.countryOfBirth, this.deathDate, this.familyName, this.familyNamePrefix, this.formattedName, this.fullName, this.gender, this.generation, this.givenName, this.legalName, this.location, this.maritalStatus, this.middleName, this.nationality, this.placeOfBirth, this.preferredGivenName, this.title, this.contactMedium, this.creditRating, this.disability, this.externalReference, this.individualIdentification, this.languageAbility, this.otherName, this.partyCharacteristic, this.relatedParty, this.skill, this.status, this.taxExemptionCertificate, this.baseType, this.schemaLocation, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IndividualUpdate {\n");
        sb.append("    aristocraticTitle: ").append(this.toIndentedString(this.aristocraticTitle)).append("\n");
        sb.append("    birthDate: ").append(this.toIndentedString(this.birthDate)).append("\n");
        sb.append("    countryOfBirth: ").append(this.toIndentedString(this.countryOfBirth)).append("\n");
        sb.append("    deathDate: ").append(this.toIndentedString(this.deathDate)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    familyNamePrefix: ").append(this.toIndentedString(this.familyNamePrefix)).append("\n");
        sb.append("    formattedName: ").append(this.toIndentedString(this.formattedName)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("    generation: ").append(this.toIndentedString(this.generation)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    maritalStatus: ").append(this.toIndentedString(this.maritalStatus)).append("\n");
        sb.append("    middleName: ").append(this.toIndentedString(this.middleName)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    placeOfBirth: ").append(this.toIndentedString(this.placeOfBirth)).append("\n");
        sb.append("    preferredGivenName: ").append(this.toIndentedString(this.preferredGivenName)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    contactMedium: ").append(this.toIndentedString(this.contactMedium)).append("\n");
        sb.append("    creditRating: ").append(this.toIndentedString(this.creditRating)).append("\n");
        sb.append("    disability: ").append(this.toIndentedString(this.disability)).append("\n");
        sb.append("    externalReference: ").append(this.toIndentedString(this.externalReference)).append("\n");
        sb.append("    individualIdentification: ").append(this.toIndentedString(this.individualIdentification)).append("\n");
        sb.append("    languageAbility: ").append(this.toIndentedString(this.languageAbility)).append("\n");
        sb.append("    otherName: ").append(this.toIndentedString(this.otherName)).append("\n");
        sb.append("    partyCharacteristic: ").append(this.toIndentedString(this.partyCharacteristic)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    skill: ").append(this.toIndentedString(this.skill)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    taxExemptionCertificate: ").append(this.toIndentedString(this.taxExemptionCertificate)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

