/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Represents our registration of information used as proof of identity by an individual (passport, national identity card, drivers license, social security number, birth certificate)")
@Validated
@Entity
public class IndividualIdentification
extends BaseRootEntity {
    @JsonProperty(value="identificationId")
    private String identificationId = null;
    @JsonProperty(value="identificationType")
    private String identificationType = null;
    @JsonProperty(value="issuingAuthority")
    private String issuingAuthority = null;
    private OffsetDateTime issuingDate = null;
    @JsonProperty(value="attachment")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="attachmentrv_refid", referencedColumnName="uuid")
    private AttachmentRefOrValue attachment = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public IndividualIdentification identificationId(String identificationId) {
        this.identificationId = identificationId;
        return this;
    }

    @Schema(description="Identifier")
    public String getIdentificationId() {
        return this.identificationId;
    }

    public void setIdentificationId(String identificationId) {
        this.identificationId = identificationId;
    }

    public IndividualIdentification identificationType(String identificationType) {
        this.identificationType = identificationType;
        return this;
    }

    @Schema(description="Identification type (passport, national identity card, drivers license, social security number, birth certificate)")
    public String getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(String identificationType) {
        this.identificationType = identificationType;
    }

    public IndividualIdentification issuingAuthority(String issuingAuthority) {
        this.issuingAuthority = issuingAuthority;
        return this;
    }

    @Schema(description="Authority which has issued the identifier, such as: social security, town hall")
    public String getIssuingAuthority() {
        return this.issuingAuthority;
    }

    public void setIssuingAuthority(String issuingAuthority) {
        this.issuingAuthority = issuingAuthority;
    }

    public IndividualIdentification issuingDate(OffsetDateTime issuingDate) {
        this.issuingDate = issuingDate;
        return this;
    }

    @Schema(description="Date at which the identifier was issued")
    @Valid
    @JsonProperty(value="issuingDate")
    public String getIssuingDateString() {
        return this.issuingDate.toString();
    }

    public OffsetDateTime getIssuingDate() {
        return this.issuingDate;
    }

    public void setIssuingDate(OffsetDateTime issuingDate) {
        this.issuingDate = issuingDate;
    }

    public IndividualIdentification attachment(AttachmentRefOrValue attachment) {
        this.attachment = attachment;
        return this;
    }

    @Schema(description="")
    @Valid
    public AttachmentRefOrValue getAttachment() {
        return this.attachment;
    }

    public void setAttachment(AttachmentRefOrValue attachment) {
        this.attachment = attachment;
    }

    public IndividualIdentification validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the identification information is valid.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndividualIdentification individualIdentification = (IndividualIdentification)o;
        return Objects.equals(this.identificationId, individualIdentification.identificationId) && Objects.equals(this.identificationType, individualIdentification.identificationType) && Objects.equals(this.issuingAuthority, individualIdentification.issuingAuthority) && Objects.equals(this.issuingDate, individualIdentification.issuingDate) && Objects.equals(this.attachment, individualIdentification.attachment) && Objects.equals(this.validFor, individualIdentification.validFor) && Objects.equals(this.baseType, individualIdentification.baseType) && Objects.equals(this.schemaLocation, individualIdentification.schemaLocation) && Objects.equals(this.type, individualIdentification.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IndividualIdentification {\n");
        sb.append("    identificationId: ").append(this.toIndentedString(this.identificationId)).append("\n");
        sb.append("    identificationType: ").append(this.toIndentedString(this.identificationType)).append("\n");
        sb.append("    issuingAuthority: ").append(this.toIndentedString(this.issuingAuthority)).append("\n");
        sb.append("    issuingDate: ").append(this.toIndentedString(this.issuingDate)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

