/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.pm632.model.IndividualCreateEventPayload;
import org.springframework.validation.annotation.Validated;

@Schema(description="The notification data structure")
@Validated
public class IndividualCreateEvent {
    @JsonProperty(value="eventId")
    private String eventId = null;
    @JsonProperty(value="eventTime")
    private OffsetDateTime eventTime = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="timeOcurred")
    private OffsetDateTime timeOcurred = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="eventType")
    private String eventType = null;
    @JsonProperty(value="domain")
    private String domain = null;
    @JsonProperty(value="priority")
    private String priority = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="correlationId")
    private String correlationId = null;
    @JsonProperty(value="event")
    private IndividualCreateEventPayload event = null;

    public IndividualCreateEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(description="The identifier of the notification.")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public IndividualCreateEvent eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Schema(description="Time of the event occurrence.")
    @Valid
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public IndividualCreateEvent description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="An explnatory of the event.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IndividualCreateEvent timeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
        return this;
    }

    @Schema(description="The time the event occured.")
    @Valid
    public OffsetDateTime getTimeOcurred() {
        return this.timeOcurred;
    }

    public void setTimeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
    }

    public IndividualCreateEvent title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The title of the event.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public IndividualCreateEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="The type of the notification.")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public IndividualCreateEvent domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(description="The domain of the event.")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public IndividualCreateEvent priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A priority.")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public IndividualCreateEvent href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the ProcessFlow")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public IndividualCreateEvent id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of the Process flow")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IndividualCreateEvent correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Schema(description="The correlation id for this event.")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public IndividualCreateEvent event(IndividualCreateEventPayload event) {
        this.event = event;
        return this;
    }

    @Schema(description="The event payload linked to the involved resource object")
    @Valid
    public IndividualCreateEventPayload getEvent() {
        return this.event;
    }

    public void setEvent(IndividualCreateEventPayload event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndividualCreateEvent individualCreateEvent = (IndividualCreateEvent)o;
        return Objects.equals(this.eventId, individualCreateEvent.eventId) && Objects.equals(this.eventTime, individualCreateEvent.eventTime) && Objects.equals(this.description, individualCreateEvent.description) && Objects.equals(this.timeOcurred, individualCreateEvent.timeOcurred) && Objects.equals(this.title, individualCreateEvent.title) && Objects.equals(this.eventType, individualCreateEvent.eventType) && Objects.equals(this.domain, individualCreateEvent.domain) && Objects.equals(this.priority, individualCreateEvent.priority) && Objects.equals(this.href, individualCreateEvent.href) && Objects.equals(this.id, individualCreateEvent.id) && Objects.equals(this.correlationId, individualCreateEvent.correlationId) && Objects.equals(this.event, individualCreateEvent.event);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventTime, this.description, this.timeOcurred, this.title, this.eventType, this.domain, this.priority, this.href, this.id, this.correlationId, this.event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IndividualCreateEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    timeOcurred: ").append(this.toIndentedString(this.timeOcurred)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

