/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.pm632.model.IndividualAttributeValueChangeEventPayload;
import org.springframework.validation.annotation.Validated;

@Schema(description="The notification data structure")
@Validated
public class IndividualAttributeValueChangeEvent {
    @JsonProperty(value="eventId")
    private String eventId = null;
    @JsonProperty(value="fieldPath")
    private String fieldPath = null;
    @JsonProperty(value="eventTime")
    private OffsetDateTime eventTime = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="timeOcurred")
    private OffsetDateTime timeOcurred = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="eventType")
    private String eventType = null;
    @JsonProperty(value="domain")
    private String domain = null;
    @JsonProperty(value="priority")
    private String priority = null;
    @JsonProperty(value="correlationId")
    private String correlationId = null;
    @JsonProperty(value="event")
    private IndividualAttributeValueChangeEventPayload event = null;

    public IndividualAttributeValueChangeEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(description="The identifier of the notification.")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public IndividualAttributeValueChangeEvent fieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return this;
    }

    @Schema(description="The path identifying the object field concerned by this notification.")
    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    public IndividualAttributeValueChangeEvent eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Schema(description="Time of the event occurrence.")
    @Valid
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public IndividualAttributeValueChangeEvent description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="An explnatory of the event.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IndividualAttributeValueChangeEvent timeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
        return this;
    }

    @Schema(description="The time the event occured.")
    @Valid
    public OffsetDateTime getTimeOcurred() {
        return this.timeOcurred;
    }

    public void setTimeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
    }

    public IndividualAttributeValueChangeEvent title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The title of the event.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public IndividualAttributeValueChangeEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="The type of the notification.")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public IndividualAttributeValueChangeEvent domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(description="The domain of the event.")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public IndividualAttributeValueChangeEvent priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A priority.")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public IndividualAttributeValueChangeEvent correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Schema(description="The correlation id for this event.")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public IndividualAttributeValueChangeEvent event(IndividualAttributeValueChangeEventPayload event) {
        this.event = event;
        return this;
    }

    @Schema(description="The event payload linked to the involved resource object")
    @Valid
    public IndividualAttributeValueChangeEventPayload getEvent() {
        return this.event;
    }

    public void setEvent(IndividualAttributeValueChangeEventPayload event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndividualAttributeValueChangeEvent individualAttributeValueChangeEvent = (IndividualAttributeValueChangeEvent)o;
        return Objects.equals(this.eventId, individualAttributeValueChangeEvent.eventId) && Objects.equals(this.fieldPath, individualAttributeValueChangeEvent.fieldPath) && Objects.equals(this.eventTime, individualAttributeValueChangeEvent.eventTime) && Objects.equals(this.description, individualAttributeValueChangeEvent.description) && Objects.equals(this.timeOcurred, individualAttributeValueChangeEvent.timeOcurred) && Objects.equals(this.title, individualAttributeValueChangeEvent.title) && Objects.equals(this.eventType, individualAttributeValueChangeEvent.eventType) && Objects.equals(this.domain, individualAttributeValueChangeEvent.domain) && Objects.equals(this.priority, individualAttributeValueChangeEvent.priority) && Objects.equals(this.correlationId, individualAttributeValueChangeEvent.correlationId) && Objects.equals(this.event, individualAttributeValueChangeEvent.event);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.fieldPath, this.eventTime, this.description, this.timeOcurred, this.title, this.eventType, this.domain, this.priority, this.correlationId, this.event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IndividualAttributeValueChangeEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    fieldPath: ").append(this.toIndentedString(this.fieldPath)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    timeOcurred: ").append(this.toIndentedString(this.timeOcurred)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

