/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm632.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.ContactMedium;
import org.etsi.osl.tmf.pm632.model.Disability;
import org.etsi.osl.tmf.pm632.model.ExternalReference;
import org.etsi.osl.tmf.pm632.model.IndividualIdentification;
import org.etsi.osl.tmf.pm632.model.IndividualStateType;
import org.etsi.osl.tmf.pm632.model.LanguageAbility;
import org.etsi.osl.tmf.pm632.model.OtherNameIndividual;
import org.etsi.osl.tmf.pm632.model.PartyCreditProfile;
import org.etsi.osl.tmf.pm632.model.Skill;
import org.etsi.osl.tmf.pm632.model.TaxExemptionCertificate;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="Individual represents a single human being (a man, woman or child). The individual can be a customer, an employee or any other person that the organization needs to store information about.")
@Validated
@Entity
@Table(indexes={@Index(name="IX_FAMILYNAME", columnList="familyName")})
public class Individual
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="aristocraticTitle")
    private String aristocraticTitle = null;
    private OffsetDateTime birthDate = null;
    @JsonProperty(value="countryOfBirth")
    private String countryOfBirth = null;
    private OffsetDateTime deathDate = null;
    @JsonProperty(value="familyName")
    private String familyName = null;
    @JsonProperty(value="familyNamePrefix")
    private String familyNamePrefix = null;
    @JsonProperty(value="formattedName")
    private String formattedName = null;
    @JsonProperty(value="fullName")
    private String fullName = null;
    @JsonProperty(value="gender")
    private String gender = null;
    @JsonProperty(value="generation")
    private String generation = null;
    @JsonProperty(value="givenName")
    private String givenName = null;
    @JsonProperty(value="legalName")
    private String legalName = null;
    @JsonProperty(value="location")
    private String location = null;
    @JsonProperty(value="maritalStatus")
    private String maritalStatus = null;
    @JsonProperty(value="middleName")
    private String middleName = null;
    @JsonProperty(value="nationality")
    private String nationality = null;
    @JsonProperty(value="placeOfBirth")
    private String placeOfBirth = null;
    @JsonProperty(value="preferredGivenName")
    private String preferredGivenName = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="contactMedium")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ContactMedium> contactMedium = new HashSet<ContactMedium>();
    @JsonProperty(value="creditRating")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PartyCreditProfile> creditRating = new HashSet<PartyCreditProfile>();
    @JsonProperty(value="disability")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Disability> disability = new HashSet<Disability>();
    @JsonProperty(value="externalReference")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ExternalReference> externalReference = new HashSet<ExternalReference>();
    @JsonProperty(value="individualIdentification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<IndividualIdentification> individualIdentification = new HashSet<IndividualIdentification>();
    @JsonProperty(value="languageAbility")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<LanguageAbility> languageAbility = new HashSet<LanguageAbility>();
    @JsonProperty(value="otherName")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<OtherNameIndividual> otherName = new HashSet<OtherNameIndividual>();
    @JsonProperty(value="partyCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Characteristic> partyCharacteristic = new HashSet<Characteristic>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="skill")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Skill> skill = new HashSet<Skill>();
    @JsonProperty(value="status")
    private IndividualStateType status = null;
    @JsonProperty(value="taxExemptionCertificate")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<TaxExemptionCertificate> taxExemptionCertificate = new HashSet<TaxExemptionCertificate>();
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    @Schema(description="Unique identifier of the organization")
    public String getId() {
        return this.uuid;
    }

    public Individual aristocraticTitle(String aristocraticTitle) {
        this.aristocraticTitle = aristocraticTitle;
        return this;
    }

    @Schema(description="e.g. Baron, Graf, Earl,\u2026")
    public String getAristocraticTitle() {
        return this.aristocraticTitle;
    }

    public void setAristocraticTitle(String aristocraticTitle) {
        this.aristocraticTitle = aristocraticTitle;
    }

    public Individual birthDate(OffsetDateTime birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    @Schema(description="Birth date")
    @Valid
    @JsonProperty(value="birthDate")
    public String getBirthDateString() {
        if (this.birthDate == null) {
            return null;
        }
        return this.birthDate.toString();
    }

    public OffsetDateTime getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(OffsetDateTime birthDate) {
        this.birthDate = birthDate;
    }

    public Individual countryOfBirth(String countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
        return this;
    }

    @Schema(description="Country where the individual was born")
    public String getCountryOfBirth() {
        return this.countryOfBirth;
    }

    public void setCountryOfBirth(String countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
    }

    public Individual deathDate(OffsetDateTime deathDate) {
        this.deathDate = deathDate;
        return this;
    }

    @Schema(description="Date of death")
    @Valid
    @JsonProperty(value="deathDate")
    public String getDeathDateStr() {
        if (this.deathDate == null) {
            return null;
        }
        return this.deathDate.toString();
    }

    public OffsetDateTime getDeathDate() {
        return this.deathDate;
    }

    public void setDeathDate(OffsetDateTime deathDate) {
        this.deathDate = deathDate;
    }

    public Individual familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Schema(description="Contains the non-chosen or inherited name. Also known as last name in the Western context")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public Individual familyNamePrefix(String familyNamePrefix) {
        this.familyNamePrefix = familyNamePrefix;
        return this;
    }

    @Schema(description="Family name prefix")
    public String getFamilyNamePrefix() {
        return this.familyNamePrefix;
    }

    public void setFamilyNamePrefix(String familyNamePrefix) {
        this.familyNamePrefix = familyNamePrefix;
    }

    public Individual formattedName(String formattedName) {
        this.formattedName = formattedName;
        return this;
    }

    @Schema(description="A fully formatted name in one string with all of its pieces in their proper place and all of the necessary punctuation. Useful for specific contexts (Chinese, Japanese, Korean,\u2026)")
    public String getFormattedName() {
        return this.formattedName;
    }

    public void setFormattedName(String formattedName) {
        this.formattedName = formattedName;
    }

    public Individual fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Schema(description="Full name flatten (first, middle, and last names)")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Individual gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="Gender")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public Individual generation(String generation) {
        this.generation = generation;
        return this;
    }

    @Schema(description="e.g.. Sr, Jr, III (the third),\u2026")
    public String getGeneration() {
        return this.generation;
    }

    public void setGeneration(String generation) {
        this.generation = generation;
    }

    public Individual givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Schema(description="First name of the individual")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public Individual legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Schema(description="Legal name or birth name (name one has for official purposes)")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public Individual location(String location) {
        this.location = location;
        return this;
    }

    @Schema(description="Temporary current location od the individual (may be used if the individual has approved its sharing)")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Individual maritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
        return this;
    }

    @Schema(description="Marital status (married, divorced, widow ...)")
    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public Individual middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    @Schema(description="Middles name or initial")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public Individual nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @Schema(description="Nationality")
    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public Individual placeOfBirth(String placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
        return this;
    }

    @Schema(description="Reference to the place where the individual was born")
    public String getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public void setPlaceOfBirth(String placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
    }

    public Individual preferredGivenName(String preferredGivenName) {
        this.preferredGivenName = preferredGivenName;
        return this;
    }

    @Schema(description="Contains the chosen name by which the individual prefers to be addressed. Note: This name may be a name other than a given name, such as a nickname")
    public String getPreferredGivenName() {
        return this.preferredGivenName;
    }

    public void setPreferredGivenName(String preferredGivenName) {
        this.preferredGivenName = preferredGivenName;
    }

    public Individual title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="Useful for titles (aristocratic, social,...) Pr, Dr, Sir, ...")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Individual contactMedium(Set<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
        return this;
    }

    public Individual addContactMediumItem(ContactMedium contactMediumItem) {
        if (this.contactMedium == null) {
            this.contactMedium = new HashSet<ContactMedium>();
        }
        this.contactMedium.add(contactMediumItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ContactMedium> getContactMedium() {
        return this.contactMedium;
    }

    public void setContactMedium(Set<ContactMedium> contactMedium) {
        this.contactMedium = contactMedium;
    }

    public Individual creditRating(Set<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
        return this;
    }

    public Individual addCreditRatingItem(PartyCreditProfile creditRatingItem) {
        if (this.creditRating == null) {
            this.creditRating = new HashSet<PartyCreditProfile>();
        }
        this.creditRating.add(creditRatingItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<PartyCreditProfile> getCreditRating() {
        return this.creditRating;
    }

    public void setCreditRating(Set<PartyCreditProfile> creditRating) {
        this.creditRating = creditRating;
    }

    public Individual disability(Set<Disability> disability) {
        this.disability = disability;
        return this;
    }

    public Individual addDisabilityItem(Disability disabilityItem) {
        if (this.disability == null) {
            this.disability = new HashSet<Disability>();
        }
        this.disability.add(disabilityItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Disability> getDisability() {
        return this.disability;
    }

    public void setDisability(Set<Disability> disability) {
        this.disability = disability;
    }

    public Individual externalReference(Set<ExternalReference> externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public Individual addExternalReferenceItem(ExternalReference externalReferenceItem) {
        if (this.externalReference == null) {
            this.externalReference = new HashSet<ExternalReference>();
        }
        this.externalReference.add(externalReferenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(Set<ExternalReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Individual individualIdentification(Set<IndividualIdentification> individualIdentification) {
        this.individualIdentification = individualIdentification;
        return this;
    }

    public Individual addIndividualIdentificationItem(IndividualIdentification individualIdentificationItem) {
        if (this.individualIdentification == null) {
            this.individualIdentification = new HashSet<IndividualIdentification>();
        }
        this.individualIdentification.add(individualIdentificationItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<IndividualIdentification> getIndividualIdentification() {
        return this.individualIdentification;
    }

    public void setIndividualIdentification(Set<IndividualIdentification> individualIdentification) {
        this.individualIdentification = individualIdentification;
    }

    public Individual languageAbility(Set<LanguageAbility> languageAbility) {
        this.languageAbility = languageAbility;
        return this;
    }

    public Individual addLanguageAbilityItem(LanguageAbility languageAbilityItem) {
        if (this.languageAbility == null) {
            this.languageAbility = new HashSet<LanguageAbility>();
        }
        this.languageAbility.add(languageAbilityItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<LanguageAbility> getLanguageAbility() {
        return this.languageAbility;
    }

    public void setLanguageAbility(Set<LanguageAbility> languageAbility) {
        this.languageAbility = languageAbility;
    }

    public Individual otherName(Set<OtherNameIndividual> otherName) {
        this.otherName = otherName;
        return this;
    }

    public Individual addOtherNameItem(OtherNameIndividual otherNameItem) {
        if (this.otherName == null) {
            this.otherName = new HashSet<OtherNameIndividual>();
        }
        this.otherName.add(otherNameItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<OtherNameIndividual> getOtherName() {
        return this.otherName;
    }

    public void setOtherName(Set<OtherNameIndividual> otherName) {
        this.otherName = otherName;
    }

    public Individual partyCharacteristic(Set<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
        return this;
    }

    public Individual addPartyCharacteristicItem(Characteristic partyCharacteristicItem) {
        if (this.partyCharacteristic == null) {
            this.partyCharacteristic = new HashSet<Characteristic>();
        }
        this.partyCharacteristic.add(partyCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Characteristic> getPartyCharacteristic() {
        return this.partyCharacteristic;
    }

    public void setPartyCharacteristic(Set<Characteristic> partyCharacteristic) {
        this.partyCharacteristic = partyCharacteristic;
    }

    public Individual relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Individual addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Individual skill(Set<Skill> skill) {
        this.skill = skill;
        return this;
    }

    public Individual addSkillItem(Skill skillItem) {
        if (this.skill == null) {
            this.skill = new HashSet<Skill>();
        }
        this.skill.add(skillItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Skill> getSkill() {
        return this.skill;
    }

    public void setSkill(Set<Skill> skill) {
        this.skill = skill;
    }

    public Individual status(IndividualStateType status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the individual")
    @Valid
    public IndividualStateType getStatus() {
        return this.status;
    }

    public void setStatus(IndividualStateType status) {
        this.status = status;
    }

    public Individual taxExemptionCertificate(Set<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
        return this;
    }

    public Individual addTaxExemptionCertificateItem(TaxExemptionCertificate taxExemptionCertificateItem) {
        if (this.taxExemptionCertificate == null) {
            this.taxExemptionCertificate = new HashSet<TaxExemptionCertificate>();
        }
        this.taxExemptionCertificate.add(taxExemptionCertificateItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<TaxExemptionCertificate> getTaxExemptionCertificate() {
        return this.taxExemptionCertificate;
    }

    public void setTaxExemptionCertificate(Set<TaxExemptionCertificate> taxExemptionCertificate) {
        this.taxExemptionCertificate = taxExemptionCertificate;
    }

    @Override
    public Individual baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public Individual schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public Individual type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Individual individual = (Individual)o;
        return Objects.equals(this.uuid, individual.uuid) && Objects.equals(this.href, individual.href) && Objects.equals(this.aristocraticTitle, individual.aristocraticTitle) && Objects.equals(this.birthDate, individual.birthDate) && Objects.equals(this.countryOfBirth, individual.countryOfBirth) && Objects.equals(this.deathDate, individual.deathDate) && Objects.equals(this.familyName, individual.familyName) && Objects.equals(this.familyNamePrefix, individual.familyNamePrefix) && Objects.equals(this.formattedName, individual.formattedName) && Objects.equals(this.fullName, individual.fullName) && Objects.equals(this.gender, individual.gender) && Objects.equals(this.generation, individual.generation) && Objects.equals(this.givenName, individual.givenName) && Objects.equals(this.legalName, individual.legalName) && Objects.equals(this.location, individual.location) && Objects.equals(this.maritalStatus, individual.maritalStatus) && Objects.equals(this.middleName, individual.middleName) && Objects.equals(this.nationality, individual.nationality) && Objects.equals(this.placeOfBirth, individual.placeOfBirth) && Objects.equals(this.preferredGivenName, individual.preferredGivenName) && Objects.equals(this.title, individual.title) && Objects.equals(this.contactMedium, individual.contactMedium) && Objects.equals(this.creditRating, individual.creditRating) && Objects.equals(this.disability, individual.disability) && Objects.equals(this.externalReference, individual.externalReference) && Objects.equals(this.individualIdentification, individual.individualIdentification) && Objects.equals(this.languageAbility, individual.languageAbility) && Objects.equals(this.otherName, individual.otherName) && Objects.equals(this.partyCharacteristic, individual.partyCharacteristic) && Objects.equals(this.relatedParty, individual.relatedParty) && Objects.equals(this.skill, individual.skill) && Objects.equals((Object)this.status, (Object)individual.status) && Objects.equals(this.taxExemptionCertificate, individual.taxExemptionCertificate) && Objects.equals(this.baseType, individual.baseType) && Objects.equals(this.schemaLocation, individual.schemaLocation) && Objects.equals(this.type, individual.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Individual {\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    aristocraticTitle: ").append(this.toIndentedString(this.aristocraticTitle)).append("\n");
        sb.append("    birthDate: ").append(this.toIndentedString(this.birthDate)).append("\n");
        sb.append("    countryOfBirth: ").append(this.toIndentedString(this.countryOfBirth)).append("\n");
        sb.append("    deathDate: ").append(this.toIndentedString(this.deathDate)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    familyNamePrefix: ").append(this.toIndentedString(this.familyNamePrefix)).append("\n");
        sb.append("    formattedName: ").append(this.toIndentedString(this.formattedName)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("    generation: ").append(this.toIndentedString(this.generation)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    maritalStatus: ").append(this.toIndentedString(this.maritalStatus)).append("\n");
        sb.append("    middleName: ").append(this.toIndentedString(this.middleName)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    placeOfBirth: ").append(this.toIndentedString(this.placeOfBirth)).append("\n");
        sb.append("    preferredGivenName: ").append(this.toIndentedString(this.preferredGivenName)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    contactMedium: ").append(this.toIndentedString(this.contactMedium)).append("\n");
        sb.append("    creditRating: ").append(this.toIndentedString(this.creditRating)).append("\n");
        sb.append("    disability: ").append(this.toIndentedString(this.disability)).append("\n");
        sb.append("    externalReference: ").append(this.toIndentedString(this.externalReference)).append("\n");
        sb.append("    individualIdentification: ").append(this.toIndentedString(this.individualIdentification)).append("\n");
        sb.append("    languageAbility: ").append(this.toIndentedString(this.languageAbility)).append("\n");
        sb.append("    otherName: ").append(this.toIndentedString(this.otherName)).append("\n");
        sb.append("    partyCharacteristic: ").append(this.toIndentedString(this.partyCharacteristic)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    skill: ").append(this.toIndentedString(this.skill)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    taxExemptionCertificate: ").append(this.toIndentedString(this.taxExemptionCertificate)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

